/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.ProxySerializer;
import com.google.web.bindery.requestfactory.shared.ProxyStore;
import com.google.web.bindery.requestfactory.shared.WriteOperation;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestContext;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestFactory;
import com.google.web.bindery.requestfactory.shared.impl.BaseProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.IdFactory;
import com.google.web.bindery.requestfactory.shared.impl.MessageFactoryHolder;
import com.google.web.bindery.requestfactory.shared.impl.SimpleEntityProxyId;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import com.google.web.bindery.requestfactory.shared.messages.IdMessage;
import com.google.web.bindery.requestfactory.shared.messages.OperationMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ProxySerializerImpl
extends AbstractRequestContext
implements ProxySerializer {
    private final ProxyStore store;
    private final Map<SimpleProxyId<?>, SimpleProxyId<?>> syntheticIds = new HashMap();
    private final Set<SimpleProxyId<?>> restored = new HashSet();
    private final Map<SimpleProxyId<?>, AutoBean<?>> serialized = new HashMap();

    public ProxySerializerImpl(AbstractRequestFactory factory, ProxyStore store) {
        super(factory, AbstractRequestContext.Dialect.STANDARD);
        this.store = store;
    }

    @Override
    public <T extends BaseProxy> T deserialize(Class<T> proxyType, String key) {
        if (this.store.get(key) == null) {
            return null;
        }
        OperationMessage op = this.getOperation(key);
        SimpleProxyId<BaseProxy> id = this.getId(op);
        return (T)this.doDeserialize(id);
    }

    @Override
    public <T extends EntityProxy> T deserialize(EntityProxyId<T> id) {
        return (T)((EntityProxy)this.doDeserialize((SimpleEntityProxyId)id));
    }

    @Override
    public Splittable getSerializedProxyId(SimpleProxyId<?> stableId) {
        return super.getSerializedProxyId(this.serializedId(stableId));
    }

    @Override
    public String serialize(BaseProxy rootObject) {
        if (rootObject == null) {
            return "null";
        }
        final AutoBean root = AutoBeanUtils.getAutoBean(rootObject);
        if (root == null) {
            throw new IllegalArgumentException();
        }
        SimpleProxyId id = this.serializedId(BaseProxyCategory.stableId(root));
        if (!$assertionsDisabled && id.isEphemeral()) {
            String string = String.valueOf(id.toString());
            throw new AssertionError((Object)(string.length() != 0 ? "Unexpected ephemeral id ".concat(string) : new String("Unexpected ephemeral id ")));
        }
        AutoBean<?> previous = this.serialized.get(id);
        if (previous == null || !previous.isFrozen()) {
            this.serialized.put(id, root);
            this.serializeOneProxy(id, root);
            root.accept(new AutoBeanVisitor(){

                @Override
                public void endVisit(AutoBean<?> bean, AutoBeanVisitor.Context ctx) {
                    if (bean == root) {
                        return;
                    }
                    if (ProxySerializerImpl.this.isEntityType(bean.getType()) || ProxySerializerImpl.this.isValueType(bean.getType())) {
                        ProxySerializerImpl.this.serialize((BaseProxy)bean.as());
                    }
                }

                @Override
                public void endVisitCollectionProperty(String propertyName, AutoBean<Collection<?>> value, AutoBeanVisitor.CollectionPropertyContext ctx) {
                    if (value == null) {
                        return;
                    }
                    if (ProxySerializerImpl.this.isEntityType(ctx.getElementType()) || ProxySerializerImpl.this.isValueType(ctx.getElementType())) {
                        for (Object o : value.as()) {
                            ProxySerializerImpl.this.serialize((BaseProxy)o);
                        }
                    }
                }

                @Override
                public void endVisitMapProperty(String propertyName, AutoBean<Map<?, ?>> value, AutoBeanVisitor.MapPropertyContext ctx) {
                    if (value == null) {
                        return;
                    }
                    for (Map.Entry<?, ?> entry : value.as().entrySet()) {
                        if (ProxySerializerImpl.this.isEntityType(ctx.getKeyType()) || ProxySerializerImpl.this.isValueType(ctx.getKeyType())) {
                            ProxySerializerImpl.this.serialize((BaseProxy)entry.getKey());
                        }
                        if (!ProxySerializerImpl.this.isEntityType(ctx.getValueType()) && !ProxySerializerImpl.this.isValueType(ctx.getValueType())) continue;
                        ProxySerializerImpl.this.serialize((BaseProxy)entry.getValue());
                    }
                }
            });
        }
        return ((IdFactory)this.getRequestFactory()).getHistoryToken(id);
    }

    @Override
    protected AutoBeanFactory getAutoBeanFactory() {
        return this.getRequestFactory().getAutoBeanFactory();
    }

    @Override
    SimpleProxyId<BaseProxy> getId(IdMessage op) {
        if (IdMessage.Strength.SYNTHETIC.equals((Object)op.getStrength())) {
            return this.getRequestFactory().allocateSyntheticId(this.getRequestFactory().getTypeFromToken(op.getTypeToken()), op.getSyntheticId());
        }
        return super.getId(op);
    }

    @Override
    <Q extends BaseProxy> AutoBean<Q> getProxyForReturnPayloadGraph(SimpleProxyId<Q> id) {
        AutoBean<Q> toReturn = super.getProxyForReturnPayloadGraph(id);
        if (this.restored.add(id)) {
            OperationMessage op = this.getOperation(((IdFactory)this.getRequestFactory()).getHistoryToken(id));
            this.processReturnOperation(id, op, new WriteOperation[0]);
            toReturn.setTag("stableId", super.getId(op));
        }
        return toReturn;
    }

    private void clear() {
        this.syntheticIds.clear();
        this.restored.clear();
        this.serialized.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BaseProxy> T doDeserialize(SimpleProxyId<T> id) {
        try {
            BaseProxy baseProxy = (BaseProxy)this.getProxyForReturnPayloadGraph(id).as();
            return (T)baseProxy;
        }
        catch (NoDataException e) {
            T t = null;
            return t;
        }
        finally {
            this.clear();
        }
    }

    private OperationMessage getOperation(String key) {
        Splittable data = this.store.get(key);
        if (data == null) {
            throw new NoDataException();
        }
        OperationMessage op = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, OperationMessage.class, data).as();
        return op;
    }

    private <T extends BaseProxy> SimpleProxyId<T> serializedId(SimpleProxyId<T> stableId) {
        assert (!stableId.isSynthetic());
        if (stableId.isEphemeral()) {
            SimpleProxyId<Object> syntheticId = this.syntheticIds.get(stableId);
            if (syntheticId == null) {
                int nextId = this.store.nextId();
                assert (nextId >= 0) : new StringBuilder(58).append("ProxyStore.nextId() returned a negative number ").append(nextId).toString();
                syntheticId = this.getRequestFactory().allocateSyntheticId(stableId.getProxyClass(), nextId + 1);
                this.syntheticIds.put(stableId, syntheticId);
            }
            return syntheticId;
        }
        return stableId;
    }

    private void serializeOneProxy(SimpleProxyId<?> idForSerialization, AutoBean<? extends BaseProxy> bean) {
        AutoBean<OperationMessage> op = this.makeOperationMessage(this.serializedId(BaseProxyCategory.stableId(bean)), bean, false);
        this.store.put(((IdFactory)this.getRequestFactory()).getHistoryToken(idForSerialization), AutoBeanCodex.encode(op));
    }

    private static class NoDataException
    extends RuntimeException {
        private NoDataException() {
        }
    }
}

