/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.regexfilter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class RegexFilter {
    private final List<String> values;
    private final ArrayList<Pattern> typePatterns;
    private final ArrayList<Boolean> includeType;

    public RegexFilter(TreeLogger logger, List<String> values) throws UnableToCompleteException {
        this.values = values;
        int size = values.size();
        this.typePatterns = new ArrayList(size);
        this.includeType = new ArrayList(size);
        for (String regex : values) {
            String string;
            boolean include = this.entriesArePositiveByDefault();
            if (regex.length() == 0) {
                logger.log(TreeLogger.ERROR, "Got empty blacklist entry");
                throw new UnableToCompleteException();
            }
            char c = regex.charAt(0);
            if (c == '+' || c == '-') {
                regex = regex.substring(1);
                include = c == '+';
            }
            try {
                Pattern p = Pattern.compile(regex);
                this.typePatterns.add(p);
                this.includeType.add(include);
                if (!logger.isLoggable(TreeLogger.DEBUG)) continue;
                string = regex;
                logger.log(TreeLogger.DEBUG, new StringBuilder(19 + String.valueOf(string).length()).append("Got filter entry '").append(string).append("'").toString());
            }
            catch (PatternSyntaxException e) {
                string = regex;
                logger.log(TreeLogger.ERROR, new StringBuilder(29 + String.valueOf(string).length()).append("Got malformed filter entry '").append(string).append("'").toString());
                throw new UnableToCompleteException();
            }
        }
    }

    public boolean isIncluded(TreeLogger logger, String query) {
        String string = String.valueOf(query);
        logger = logger.branch(TreeLogger.DEBUG, string.length() != 0 ? "Considering query ".concat(string) : new String("Considering query "));
        int size = this.typePatterns.size();
        for (int idx = size - 1; idx >= 0; --idx) {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                String string2 = this.values.get(idx);
                logger.log(TreeLogger.DEBUG, new StringBuilder(35 + String.valueOf(string2).length() + String.valueOf(query).length()).append("Considering filter rule ").append(string2).append(" for query ").append(query).toString());
            }
            boolean include = this.includeType.get(idx);
            Pattern pattern = this.typePatterns.get(idx);
            if (!pattern.matcher(query).matches()) continue;
            if (include) {
                if (logger.isLoggable(TreeLogger.DEBUG)) {
                    String string3 = this.values.get(idx);
                    logger.log(TreeLogger.DEBUG, new StringBuilder(32 + String.valueOf(query).length() + String.valueOf(string3).length()).append("Whitelisting ").append(query).append(" according to rule ").append(string3).toString());
                }
                return true;
            }
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                String string4 = this.values.get(idx);
                logger.log(TreeLogger.DEBUG, new StringBuilder(32 + String.valueOf(query).length() + String.valueOf(string4).length()).append("Blacklisting ").append(query).append(" according to rule ").append(string4).toString());
            }
            return false;
        }
        return this.acceptByDefault();
    }

    protected abstract boolean acceptByDefault();

    protected abstract boolean entriesArePositiveByDefault();
}

