/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.CustomFieldSerializer;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.server.Base64Utils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.CharVector;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import com.google.gwt.user.server.rpc.impl.TypeNameObfuscator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class ServerSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private static final Map<Class<?>, ValueWriter> CLASS_TO_VALUE_WRITER = new IdentityHashMap();
    private static final Map<Class<?>, VectorWriter> CLASS_TO_VECTOR_WRITER = new IdentityHashMap();
    private static final int NUMBER_OF_JS_ESCAPED_CHARS = 128;
    private static final char[] JS_CHARS_ESCAPED = new char[128];
    private static final char JS_ESCAPE_CHAR = '\\';
    private static final char JS_QUOTE_CHAR = '\"';
    private static final char[] NIBBLE_TO_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char NON_BREAKING_HYPHEN = '\u2011';
    private static final int MAX_STRING_NODE_LENGTH = 65535;
    private final SerializationPolicy serializationPolicy;
    private ArrayList<String> tokenList = new ArrayList();
    private int tokenListCharCount;

    public static String escapeString(String toEscape) {
        return ServerSerializationStreamWriter.escapeString(toEscape, false, null);
    }

    public static String escapeStringSplitNodes(String toEscape) {
        return ServerSerializationStreamWriter.escapeString(toEscape, true, null);
    }

    private static String escapeString(String toEscape, boolean splitNodes, LengthConstrainedArray array) {
        int length = toEscape.length();
        int capacityIncrement = Math.max(length, 16);
        CharVector charVector = new CharVector(capacityIncrement * 2, capacityIncrement);
        charVector.add('\"');
        int i = 0;
        while (i < length) {
            int maxSegmentVectorSize;
            int n = maxSegmentVectorSize = splitNodes ? charVector.getSize() + 65535 - 5 : Integer.MAX_VALUE;
            while (i < length && charVector.getSize() < maxSegmentVectorSize) {
                char c;
                if (ServerSerializationStreamWriter.needsUnicodeEscape(c = toEscape.charAt(i++))) {
                    ServerSerializationStreamWriter.unicodeEscape(c, charVector);
                    continue;
                }
                charVector.add(c);
            }
            if (!splitNodes || i >= length) continue;
            charVector.add('\"');
            charVector.add('+');
            charVector.add('\"');
            if (array == null) continue;
            array.setJavaScript(true);
        }
        charVector.add('\"');
        return String.valueOf(charVector.asArray(), 0, charVector.getSize());
    }

    private static Class<?> getClassForSerialization(Object instance) {
        assert (instance != null);
        if (instance instanceof Enum) {
            Enum e = (Enum)instance;
            return e.getDeclaringClass();
        }
        return instance.getClass();
    }

    private static boolean needsUnicodeEscape(char ch) {
        switch (ch) {
            case ' ': {
                return false;
            }
            case '\"': 
            case '\\': {
                return true;
            }
            case '\u2011': {
                return true;
            }
            case '&': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': {
                return true;
            }
        }
        if (ch < ' ') {
            return true;
        }
        switch (Character.getType(ch)) {
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static void unicodeEscape(char ch, CharVector charVector) {
        charVector.add('\\');
        if (ch < '\u0080' && JS_CHARS_ESCAPED[ch] != '\u0000') {
            charVector.add(JS_CHARS_ESCAPED[ch]);
        } else {
            charVector.add('u');
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 12 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 8 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 4 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch & 0xF]);
        }
    }

    public ServerSerializationStreamWriter(SerializationPolicy serializationPolicy) {
        this.serializationPolicy = serializationPolicy;
    }

    public ServerSerializationStreamWriter(SerializationPolicy serializationPolicy, int version) {
        this(serializationPolicy);
        this.setVersion(version);
    }

    @Override
    public void prepareToWrite() {
        super.prepareToWrite();
        this.tokenList.clear();
        this.tokenListCharCount = 0;
    }

    public void serializeValue(Object value, Class<?> type) throws SerializationException {
        ValueWriter valueWriter = CLASS_TO_VALUE_WRITER.get(type);
        if (valueWriter != null) {
            valueWriter.write(this, value);
        } else {
            ValueWriter.OBJECT.write(this, value);
        }
    }

    @Override
    public String toString() {
        int capacityGuess = 2 * this.tokenListCharCount + 2 * this.tokenList.size();
        LengthConstrainedArray stream = new LengthConstrainedArray(capacityGuess);
        this.writePayload(stream);
        this.writeStringTable(stream);
        this.writeHeader(stream);
        return stream.toString();
    }

    @Override
    public void writeLong(long value) {
        if (this.getVersion() == 5) {
            double[] parts = ServerSerializationStreamWriter.getAsDoubleArray(value);
            assert (parts != null && parts.length == 2);
            this.writeDouble(parts[0]);
            this.writeDouble(parts[1]);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            sb.append(Base64Utils.toBase64(value));
            sb.append('\"');
            this.append(sb.toString());
        }
    }

    @Override
    public void writeDouble(double fieldValue) {
        if (this.getVersion() >= 8 && (Double.isNaN(fieldValue) || Double.isInfinite(fieldValue))) {
            String string = String.valueOf(String.valueOf(fieldValue));
            this.append(new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString());
        } else {
            super.writeDouble(fieldValue);
        }
    }

    @Override
    protected void append(String token) {
        this.tokenList.add(token);
        if (token != null) {
            this.tokenListCharCount += token.length();
        }
    }

    @Override
    protected String getObjectTypeSignature(Object instance) throws SerializationException {
        assert (instance != null);
        Class<?> clazz = ServerSerializationStreamWriter.getClassForSerialization(instance);
        if (this.hasFlags(1)) {
            if (this.serializationPolicy instanceof TypeNameObfuscator) {
                return ((TypeNameObfuscator)((Object)this.serializationPolicy)).getTypeIdForClass(clazz);
            }
            String string = String.valueOf("The GWT module was compiled with RPC type name elision enabled, but ");
            String string2 = String.valueOf(this.serializationPolicy.getClass().getName());
            String string3 = String.valueOf(TypeNameObfuscator.class.getName());
            throw new SerializationException(new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(" does not implement ").append(string3).toString());
        }
        return SerializabilityUtil.encodeSerializedInstanceReference(clazz, this.serializationPolicy);
    }

    @Override
    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        assert (instance != null);
        Class<?> clazz = ServerSerializationStreamWriter.getClassForSerialization(instance);
        try {
            this.serializationPolicy.validateSerialize(clazz);
        }
        catch (SerializationException e) {
            String string = String.valueOf(e.getMessage());
            String string2 = String.valueOf(instance);
            throw new SerializationException(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": instance = ").append(string2).toString());
        }
        this.serializeImpl(instance, clazz);
    }

    private void serializeArray(Class<?> instanceClass, Object instance) throws SerializationException {
        assert (instanceClass.isArray());
        VectorWriter instanceWriter = CLASS_TO_VECTOR_WRITER.get(instanceClass);
        if (instanceWriter != null) {
            instanceWriter.write(this, instance);
        } else {
            VectorWriter.OBJECT_VECTOR.write(this, instance);
        }
    }

    private void serializeClass(Object instance, Class<?> instanceClass) throws SerializationException {
        assert (instance != null);
        Field[] serializableFields = SerializabilityUtil.applyFieldSerializationPolicy(instanceClass, this.serializationPolicy);
        Set<String> clientFieldNames = this.serializationPolicy.getClientFieldNamesForEnhancedClass(instanceClass);
        if (clientFieldNames != null) {
            ArrayList serverFields = new ArrayList();
            for (Field declField : serializableFields) {
                assert (declField != null);
                if (clientFieldNames.contains(declField.getName())) continue;
                serverFields.add(declField);
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(serverFields.size());
                Iterator iterator = serverFields.iterator();
                while (iterator.hasNext()) {
                    Field f = (Field)iterator.next();
                    oos.writeObject(f.getName());
                    f.setAccessible(true);
                    Object fieldData = f.get(instance);
                    oos.writeObject(fieldData);
                }
                oos.close();
                byte[] serializedData = baos.toByteArray();
                String encodedData = Base64Utils.toBase64(serializedData);
                this.writeString(encodedData);
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
        for (Field declField : serializableFields) {
            boolean needsAccessOverride;
            if (clientFieldNames != null && !clientFieldNames.contains(declField.getName())) continue;
            boolean isAccessible = declField.isAccessible();
            boolean bl = needsAccessOverride = !isAccessible && !Modifier.isPublic(declField.getModifiers());
            if (needsAccessOverride) {
                declField.setAccessible(true);
            }
            try {
                Object value = declField.get(instance);
                this.serializeValue(value, declField.getType());
            }
            catch (IllegalArgumentException e) {
                throw new SerializationException(e);
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
        }
        Class<?> superClass = instanceClass.getSuperclass();
        if (this.serializationPolicy.shouldSerializeFields(superClass)) {
            this.serializeImpl(instance, superClass);
        }
    }

    private void serializeImpl(Object instance, Class<?> instanceClass) throws SerializationException {
        assert (instance != null);
        Class<?> customSerializer = SerializabilityUtil.hasCustomFieldSerializer(instanceClass);
        if (customSerializer != null) {
            CustomFieldSerializer<?> customFieldSerializer = SerializabilityUtil.loadCustomFieldSerializer(customSerializer);
            if (customFieldSerializer == null) {
                this.serializeWithCustomSerializer(customSerializer, instance, instanceClass);
            } else {
                customFieldSerializer.serializeInstance(this, instance);
            }
        } else if (instanceClass.isArray()) {
            this.serializeArray(instanceClass, instance);
        } else if (instanceClass.isEnum()) {
            this.writeInt(((Enum)instance).ordinal());
        } else {
            this.serializeClass(instance, instanceClass);
        }
    }

    private void serializeWithCustomSerializer(Class<?> customSerializer, Object instance, Class<?> instanceClass) throws SerializationException {
        try {
            assert (!instanceClass.isArray());
            for (Method method : customSerializer.getMethods()) {
                if (!"serialize".equals(method.getName())) continue;
                method.invoke(null, this, instance);
                return;
            }
            throw new NoSuchMethodException("serialize");
        }
        catch (SecurityException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
    }

    private void writeHeader(LengthConstrainedArray stream) {
        stream.addToken(this.getFlags());
        if (stream.isJavaScript() && this.getVersion() >= 8) {
            stream.addToken(7);
        } else {
            stream.addToken(this.getVersion());
        }
    }

    private void writePayload(LengthConstrainedArray stream) {
        ListIterator<String> tokenIterator = this.tokenList.listIterator(this.tokenList.size());
        while (tokenIterator.hasPrevious()) {
            stream.addToken(tokenIterator.previous());
        }
    }

    private void writeStringTable(LengthConstrainedArray stream) {
        LengthConstrainedArray tableStream = new LengthConstrainedArray();
        for (String s : this.getStringTable()) {
            tableStream.addEscapedToken(s);
        }
        stream.addToken(tableStream.toString());
        stream.setJavaScript(stream.isJavaScript() || tableStream.isJavaScript());
    }

    static {
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[8] = 98;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[9] = 116;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[10] = 110;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[12] = 102;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[13] = 114;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[92] = 92;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[34] = 34;
        CLASS_TO_VECTOR_WRITER.put(boolean[].class, VectorWriter.BOOLEAN_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(byte[].class, VectorWriter.BYTE_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(char[].class, VectorWriter.CHAR_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(double[].class, VectorWriter.DOUBLE_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(float[].class, VectorWriter.FLOAT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(int[].class, VectorWriter.INT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(long[].class, VectorWriter.LONG_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(Object[].class, VectorWriter.OBJECT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(short[].class, VectorWriter.SHORT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(String[].class, VectorWriter.STRING_VECTOR);
        CLASS_TO_VALUE_WRITER.put(Boolean.TYPE, ValueWriter.BOOLEAN);
        CLASS_TO_VALUE_WRITER.put(Byte.TYPE, ValueWriter.BYTE);
        CLASS_TO_VALUE_WRITER.put(Character.TYPE, ValueWriter.CHAR);
        CLASS_TO_VALUE_WRITER.put(Double.TYPE, ValueWriter.DOUBLE);
        CLASS_TO_VALUE_WRITER.put(Float.TYPE, ValueWriter.FLOAT);
        CLASS_TO_VALUE_WRITER.put(Integer.TYPE, ValueWriter.INT);
        CLASS_TO_VALUE_WRITER.put(Long.TYPE, ValueWriter.LONG);
        CLASS_TO_VALUE_WRITER.put(Object.class, ValueWriter.OBJECT);
        CLASS_TO_VALUE_WRITER.put(Short.TYPE, ValueWriter.SHORT);
        CLASS_TO_VALUE_WRITER.put(String.class, ValueWriter.STRING);
    }

    private static enum VectorWriter {
        BOOLEAN_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                boolean[] vector = (boolean[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeBoolean(vector[i]);
                }
            }
        }
        ,
        BYTE_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                byte[] vector = (byte[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeByte(vector[i]);
                }
            }
        }
        ,
        CHAR_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                char[] vector = (char[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeChar(vector[i]);
                }
            }
        }
        ,
        DOUBLE_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                double[] vector = (double[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeDouble(vector[i]);
                }
            }
        }
        ,
        FLOAT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                float[] vector = (float[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeFloat(vector[i]);
                }
            }
        }
        ,
        INT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                int[] vector = (int[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeInt(vector[i]);
                }
            }
        }
        ,
        LONG_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                long[] vector = (long[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeLong(vector[i]);
                }
            }
        }
        ,
        OBJECT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) throws SerializationException {
                Object[] vector = (Object[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeObject(vector[i]);
                }
            }
        }
        ,
        SHORT_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                short[] vector = (short[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeShort(vector[i]);
                }
            }
        }
        ,
        STRING_VECTOR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                String[] vector = (String[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeString(vector[i]);
                }
            }
        };


        abstract void write(ServerSerializationStreamWriter var1, Object var2) throws SerializationException;
    }

    private static enum ValueWriter {
        BOOLEAN{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeBoolean((Boolean)instance);
            }
        }
        ,
        BYTE{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeByte((Byte)instance);
            }
        }
        ,
        CHAR{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeChar(((Character)instance).charValue());
            }
        }
        ,
        DOUBLE{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeDouble((Double)instance);
            }
        }
        ,
        FLOAT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeFloat(((Float)instance).floatValue());
            }
        }
        ,
        INT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeInt((Integer)instance);
            }
        }
        ,
        LONG{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeLong((Long)instance);
            }
        }
        ,
        OBJECT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) throws SerializationException {
                stream.writeObject(instance);
            }
        }
        ,
        SHORT{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeShort((Short)instance);
            }
        }
        ,
        STRING{

            @Override
            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeString((String)instance);
            }
        };


        abstract void write(ServerSerializationStreamWriter var1, Object var2) throws SerializationException;
    }

    public static class LengthConstrainedArray {
        public static final int MAXIMUM_ARRAY_LENGTH = 32768;
        private static final String POSTLUDE = "])";
        private static final String PRELUDE = "].concat([";
        private final StringBuffer buffer;
        private int count = 0;
        private boolean needsComma = false;
        private int total = 0;
        private boolean javascript = false;

        public LengthConstrainedArray() {
            this.buffer = new StringBuffer();
        }

        public LengthConstrainedArray(int capacityGuess) {
            this.buffer = new StringBuffer(capacityGuess);
        }

        public void addToken(CharSequence token) {
            ++this.total;
            if (this.count++ == 32768) {
                if (this.total == 32769) {
                    this.buffer.append(PRELUDE);
                    this.javascript = true;
                } else {
                    this.buffer.append("],[");
                }
                this.count = 0;
                this.needsComma = false;
            }
            if (this.needsComma) {
                this.buffer.append(",");
            } else {
                this.needsComma = true;
            }
            this.buffer.append(token);
        }

        public void addEscapedToken(String token) {
            this.addToken(ServerSerializationStreamWriter.escapeString(token, true, this));
        }

        public void addToken(int i) {
            this.addToken(String.valueOf(i));
        }

        public boolean isJavaScript() {
            return this.javascript;
        }

        public void setJavaScript(boolean javascript) {
            this.javascript = javascript;
        }

        public String toString() {
            if (this.total > 32768) {
                String string = String.valueOf(this.buffer.toString());
                String string2 = String.valueOf(POSTLUDE);
                return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[").append(string).append(string2).toString();
            }
            String string = String.valueOf(this.buffer.toString());
            return new StringBuilder(2 + String.valueOf(string).length()).append("[").append(string).append("]").toString();
        }
    }
}

