/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssModVisitor;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import java.util.List;

public class Spriter
extends CssModVisitor {
    private final ResourceContext context;
    private final TreeLogger logger;

    public Spriter(TreeLogger logger, ResourceContext context) {
        this.logger = logger.branch(TreeLogger.DEBUG, "Creating image sprite classes");
        this.context = context;
    }

    @Override
    public void endVisit(CssSprite x, Context ctx) {
        String repeatText;
        JMethod imageMethod;
        JClassType bundleType = this.context.getClientBundleType();
        CssProperty.DotPathValue functionName = x.getResourceFunction();
        if (functionName == null) {
            String string = String.valueOf(x.getSelectors());
            String string2 = String.valueOf("gwt-image");
            this.logger.log(TreeLogger.ERROR, new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append("The @sprite rule ").append(string).append(" must specify the ").append(string2).append(" property").toString());
            throw new CssCompilerException("No image property specified");
        }
        JClassType imageResourceType = this.context.getGeneratorContext().getTypeOracle().findType(ImageResource.class.getName());
        assert (imageResourceType != null);
        try {
            imageMethod = ResourceGeneratorUtil.getMethodByPath(bundleType, functionName.getParts(), (JType)imageResourceType);
        }
        catch (NotFoundException e) {
            String string = String.valueOf(functionName);
            String string3 = String.valueOf(bundleType.getQualifiedSourceName());
            String string4 = String.valueOf(e.getMessage());
            this.logger.log(TreeLogger.ERROR, new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Unable to find ImageResource method ").append(string).append(" in ").append(string3).append(" : ").append(string4).toString());
            throw new CssCompilerException("Cannot find image function");
        }
        ImageResource.ImageOptions options = (ImageResource.ImageOptions)imageMethod.getAnnotation(ImageResource.ImageOptions.class);
        ImageResource.RepeatStyle repeatStyle = options != null ? options.repeatStyle() : ImageResource.RepeatStyle.None;
        String string = this.context.getImplementationSimpleSourceName();
        String string5 = functionName.getExpression();
        String instance = new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string5).length()).append("(").append(string).append(".this.").append(string5).append(")").toString();
        CssRule replacement = new CssRule();
        replacement.getSelectors().addAll(x.getSelectors());
        List<CssProperty> properties = replacement.getProperties();
        if (repeatStyle == ImageResource.RepeatStyle.None || repeatStyle == ImageResource.RepeatStyle.Horizontal) {
            properties.add(new CssProperty("height", new CssProperty.ExpressionValue(String.valueOf(instance).concat(".getHeight() + \"px\"")), false));
        }
        if (repeatStyle == ImageResource.RepeatStyle.None || repeatStyle == ImageResource.RepeatStyle.Vertical) {
            properties.add(new CssProperty("width", new CssProperty.ExpressionValue(String.valueOf(instance).concat(".getWidth() + \"px\"")), false));
        }
        properties.add(new CssProperty("overflow", new CssProperty.IdentValue("hidden"), false));
        switch (repeatStyle) {
            case None: {
                repeatText = " no-repeat";
                break;
            }
            case Horizontal: {
                repeatText = " repeat-x";
                break;
            }
            case Vertical: {
                repeatText = " repeat-y";
                break;
            }
            case Both: {
                repeatText = " repeat";
                break;
            }
            default: {
                String string6 = String.valueOf((Object)repeatStyle);
                throw new RuntimeException(new StringBuilder(20 + String.valueOf(string6).length()).append("Unknown repeatStyle ").append(string6).toString());
            }
        }
        String backgroundExpression = new StringBuilder(87 + String.valueOf(instance).length() + String.valueOf(instance).length() + String.valueOf(instance).length() + String.valueOf(repeatText).length()).append("\"url(\\\"\" + ").append(instance).append(".getSafeUri().asString() + \"\\\") -\" + ").append(instance).append(".getLeft() + \"px -\" + ").append(instance).append(".getTop() + \"px ").append(repeatText).append("\"").toString();
        properties.add(new CssProperty("background", new CssProperty.ExpressionValue(backgroundExpression), false));
        properties.addAll(x.getProperties());
        ctx.replaceMe(replacement);
    }
}

