/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.EditorVisitor;
import com.google.gwt.editor.client.impl.Initializer;
import com.google.gwt.editor.client.impl.RootEditorContext;
import com.google.gwt.editor.client.impl.SimpleError;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractEditorDelegate<T, E extends Editor<T>>
implements EditorDelegate<T> {
    private boolean dirty;
    private Chain<?, ?> editorChain;
    private List<EditorError> errors;
    private String path;

    protected static String appendPath(String prefix, String path) {
        if ("".equals(prefix)) {
            return path;
        }
        return new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(path).length()).append(prefix).append(".").append(path).toString();
    }

    public abstract void accept(EditorVisitor var1);

    public abstract T getObject();

    @Override
    public String getPath() {
        return this.path;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void recordError(String message, Object value, Object userData) {
        SimpleError error = new SimpleError(this, message, value, userData);
        this.errors.add(error);
    }

    public void recordError(String message, Object value, Object userData, String extraPath, Editor<?> leafEditor) {
        SimpleError error = new SimpleError(this, message, value, userData, extraPath, leafEditor);
        this.errors.add(error);
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public abstract HandlerRegistration subscribe();

    protected <R, S extends Editor<R>> void addSubDelegate(AbstractEditorDelegate<R, S> subDelegate, String path, S subEditor) {
        subDelegate.initialize(path, subEditor);
    }

    protected String appendPath(String path) {
        if (path.length() == 0) {
            return this.path;
        }
        return AbstractEditorDelegate.appendPath(this.path, path);
    }

    protected <R, S extends Editor<R>> void createChain(Class<R> composedElementType) {
        CompositeEditor editor = (CompositeEditor)this.getEditor();
        this.editorChain = new Chain(editor, composedElementType);
    }

    protected AbstractEditorDelegate<?, ?> createComposedDelegate() {
        throw new IllegalStateException();
    }

    protected EditorVisitor createInitializerVisitor() {
        return new Initializer();
    }

    protected <Q> Q ensureMutable(Q object) {
        return object;
    }

    protected abstract E getEditor();

    protected Chain<?, ?> getEditorChain() {
        return this.editorChain;
    }

    protected List<EditorError> getErrors() {
        return this.errors;
    }

    protected void initialize(String pathSoFar, E editor) {
        this.path = pathSoFar;
        this.setEditor(editor);
        this.errors = new ArrayList<EditorError>();
        this.initializeSubDelegates();
    }

    protected abstract void initializeSubDelegates();

    protected abstract void setEditor(E var1);

    protected abstract void setObject(T var1);

    protected boolean shouldFlush() {
        return true;
    }

    protected class Chain<R, S extends Editor<R>>
    implements CompositeEditor.EditorChain<R, S> {
        private final CompositeEditor<T, R, S> composedEditor;
        private final Class<R> composedElementType;
        private final Map<S, AbstractEditorDelegate<R, S>> map = new LinkedHashMap<S, AbstractEditorDelegate<R, S>>();

        Chain(CompositeEditor<T, R, S> composedEditor, Class<R> composedElementType) {
            this.composedEditor = composedEditor;
            this.composedElementType = composedElementType;
        }

        public void accept(EditorVisitor visitor) {
            for (AbstractEditorDelegate<R, S> delegate : this.map.values()) {
                this.traverse(visitor, delegate);
            }
        }

        @Override
        public void attach(R object, S subEditor) {
            String subPath;
            AbstractEditorDelegate<Object, Object> subDelegate = this.map.get(subEditor);
            String string = String.valueOf(AbstractEditorDelegate.this.path);
            String string2 = String.valueOf(this.composedEditor.getPathElement(subEditor));
            String string3 = subPath = string2.length() != 0 ? string.concat(string2) : new String(string);
            if (subDelegate == null) {
                AbstractEditorDelegate<?, ?> temp = AbstractEditorDelegate.this.createComposedDelegate();
                subDelegate = temp;
                this.map.put(subEditor, subDelegate);
                AbstractEditorDelegate.this.addSubDelegate(subDelegate, subPath, subEditor);
            } else {
                ((AbstractEditorDelegate)subDelegate).path = subPath;
            }
            subDelegate.setObject(AbstractEditorDelegate.this.ensureMutable(object));
            this.traverse(AbstractEditorDelegate.this.createInitializerVisitor(), subDelegate);
        }

        @Override
        public void detach(S subEditor) {
            this.map.remove(subEditor);
        }

        @Override
        public R getValue(S subEditor) {
            AbstractEditorDelegate<R, S> subDelegate = this.map.get(subEditor);
            if (subDelegate == null) {
                return null;
            }
            return subDelegate.getObject();
        }

        void traverse(EditorVisitor visitor, AbstractEditorDelegate<R, S> delegate) {
            R object = delegate.getObject();
            new RootEditorContext<R>(delegate, this.composedElementType, object).traverse(visitor, delegate);
        }
    }
}

