/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.IsCollapsible;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HasEnabled;

public class ButtonCellBase<C>
extends AbstractCell<C>
implements IsCollapsible,
HasEnabled {
    private char accessKey;
    private final Appearance<C> appearance;
    private Decoration decoration = Decoration.DEFAULT;
    private ImageResource icon;
    private boolean isCollapsedLeft;
    private boolean isCollapsedRight;
    private boolean isEnabled = true;
    private int tabIndex = -1;

    public ButtonCellBase(Appearance<C> appearance) {
        super("click", "keydown", "mousedown");
        this.appearance = appearance;
    }

    public char getAccessKey() {
        return this.accessKey;
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public ImageResource getIcon() {
        return this.icon;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    @Override
    public boolean isCollapseLeft() {
        return this.isCollapsedLeft;
    }

    @Override
    public boolean isCollapseRight() {
        return this.isCollapsedRight;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        if (!this.isEnabled()) {
            return;
        }
        super.onBrowserEvent(context, parent, value, event, valueUpdater);
        Element target = (Element)event.getEventTarget().cast();
        if (!parent.getFirstChildElement().isOrHasChild(target)) {
            return;
        }
        String eventType = event.getType();
        if ("click".equals(eventType)) {
            this.onEnterKeyDown(context, parent, value, event, valueUpdater);
        } else if ("mousedown".equals(eventType)) {
            this.appearance.onPush(parent);
            new UnpushHandler(parent);
            event.preventDefault();
        }
    }

    @Override
    public void render(Cell.Context context, C value, SafeHtmlBuilder sb) {
        this.appearance.render(this, context, value, sb);
    }

    public void setAccessKey(char key) {
        this.accessKey = key;
    }

    @Override
    public void setCollapseLeft(boolean isCollapsed) {
        this.isCollapsedLeft = isCollapsed;
    }

    @Override
    public void setCollapseRight(boolean isCollapsed) {
        this.isCollapsedRight = isCollapsed;
    }

    public void setDecoration(Decoration decoration) {
        this.decoration = decoration;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setFocus(Element parent, boolean focused) {
        this.appearance.setFocus(parent, focused);
    }

    public void setIcon(ImageResource icon) {
        this.icon = icon;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    @Override
    protected void onEnterKeyDown(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        if (valueUpdater != null) {
            valueUpdater.update(value);
        }
    }

    private class UnpushHandler
    implements Event.NativePreviewHandler {
        private final Element parent;
        private final HandlerRegistration reg;

        public UnpushHandler(Element parent) {
            this.parent = parent;
            this.reg = Event.addNativePreviewHandler(this);
        }

        @Override
        public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
            if ("mouseup".equals(event.getNativeEvent().getType())) {
                this.reg.removeHandler();
                ButtonCellBase.this.appearance.onUnpush(this.parent);
            }
        }
    }

    public static class DefaultAppearance<C>
    implements Appearance<C> {
        private static final int DEFAULT_ICON_PADDING = 3;
        private static Resources defaultResources;
        private static Template template;
        private SafeHtml iconSafeHtml = SafeHtmlUtils.EMPTY_SAFE_HTML;
        private ImageResource lastIcon;
        private final SafeHtmlRenderer<C> renderer;
        private final Style style;

        private static Resources getDefaultResources() {
            if (defaultResources == null) {
                defaultResources = (Resources)GWT.create(Resources.class);
            }
            return defaultResources;
        }

        public DefaultAppearance(SafeHtmlRenderer<C> renderer) {
            this(renderer, DefaultAppearance.getDefaultResources());
        }

        public DefaultAppearance(SafeHtmlRenderer<C> renderer, Resources resources) {
            this.renderer = renderer;
            this.style = resources.buttonCellBaseStyle();
            this.style.ensureInjected();
            if (template == null) {
                template = (Template)GWT.create(Template.class);
            }
        }

        public SafeHtmlRenderer<C> getRenderer() {
            return this.renderer;
        }

        @Override
        public void onPush(Element parent) {
            parent.getFirstChildElement().addClassName(this.style.buttonCellBasePushing());
        }

        @Override
        public void onUnpush(Element parent) {
            parent.getFirstChildElement().removeClassName(this.style.buttonCellBasePushing());
        }

        @Override
        public void render(ButtonCellBase<C> cell, Cell.Context context, C value, SafeHtmlBuilder sb) {
            ImageResource icon;
            SafeHtmlBuilder classes = new SafeHtmlBuilder();
            classes.appendEscaped(this.style.buttonCellBase());
            Decoration decoration = cell.getDecoration();
            if (decoration == Decoration.PRIMARY) {
                String string = String.valueOf(this.style.buttonCellBasePrimary());
                classes.appendEscaped(string.length() != 0 ? " ".concat(string) : new String(" "));
            } else if (decoration == Decoration.NEGATIVE) {
                String string = String.valueOf(this.style.buttonCellBaseNegative());
                classes.appendEscaped(string.length() != 0 ? " ".concat(string) : new String(" "));
            } else {
                String string = String.valueOf(this.style.buttonCellBaseDefault());
                classes.appendEscaped(string.length() != 0 ? " ".concat(string) : new String(" "));
            }
            if (cell.isCollapseLeft()) {
                String string = String.valueOf(this.style.buttonCellBaseCollapseLeft());
                classes.appendEscaped(string.length() != 0 ? " ".concat(string) : new String(" "));
            }
            if (cell.isCollapseRight()) {
                String string = String.valueOf(this.style.buttonCellBaseCollapseRight());
                classes.appendEscaped(string.length() != 0 ? " ".concat(string) : new String(" "));
            }
            if ((icon = cell.getIcon()) != this.lastIcon) {
                if (icon == null) {
                    this.iconSafeHtml = SafeHtmlUtils.EMPTY_SAFE_HTML;
                } else {
                    AbstractImagePrototype proto = AbstractImagePrototype.create(icon);
                    SafeHtml iconOnly = SafeHtmlUtils.fromTrustedString(proto.getHTML());
                    int halfHeight = (int)Math.round((double)icon.getHeight() / 2.0);
                    SafeStylesBuilder styles = new SafeStylesBuilder();
                    styles.marginTop(-halfHeight, Style.Unit.PX);
                    if (LocaleInfo.getCurrentLocale().isRTL()) {
                        styles.right(0.0, Style.Unit.PX);
                    } else {
                        styles.left(0.0, Style.Unit.PX);
                    }
                    this.iconSafeHtml = template.iconWrapper(styles.toSafeStyles(), iconOnly);
                }
            }
            char accessKey = cell.getAccessKey();
            StringBuilder attributes = new StringBuilder();
            if (!cell.isEnabled()) {
                attributes.append("disabled=disabled ");
            }
            if (accessKey != '\u0000') {
                attributes.append("accessKey=\"").append(SafeHtmlUtils.htmlEscape(new StringBuilder(1).append(accessKey).toString()));
                attributes.append("\" ");
            }
            SafeStylesBuilder styles = new SafeStylesBuilder();
            int iconWidth = icon == null ? 0 : icon.getWidth();
            int iconPadding = iconWidth + 3;
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                styles.paddingRight(iconPadding, Style.Unit.PX);
            } else {
                styles.paddingLeft(iconPadding, Style.Unit.PX);
            }
            SafeHtml safeValue = this.renderer.render(value);
            SafeHtml content = template.iconContentLayout(CommonResources.getInlineBlockStyle(), styles.toSafeStyles(), this.iconSafeHtml, safeValue);
            int tabIndex = cell.getTabIndex();
            StringBuilder openTag = new StringBuilder();
            openTag.append("<button type=\"button\"");
            String string = classes.toSafeHtml().asString();
            openTag.append(new StringBuilder(9 + String.valueOf(string).length()).append(" class=\"").append(string).append("\"").toString());
            openTag.append(new StringBuilder(24).append(" tabindex=\"").append(tabIndex).append("\" ").toString());
            openTag.append(attributes.toString()).append(">");
            sb.appendHtmlConstant(openTag.toString());
            sb.append(content);
            sb.appendHtmlConstant("</button>");
        }

        @Override
        public void setFocus(Element parent, boolean focused) {
            Element focusable = (Element)parent.getFirstChildElement().cast();
            if (focused) {
                focusable.focus();
            } else {
                focusable.blur();
            }
        }

        static interface Template
        extends SafeHtmlTemplates {
            @SafeHtmlTemplates.Template(value="<div class=\"{0}\" style=\"{1}position:relative;zoom:0;\">{2}{3}</div>")
            public SafeHtml iconContentLayout(String var1, SafeStyles var2, SafeHtml var3, SafeHtml var4);

            @SafeHtmlTemplates.Template(value="<div style=\"{0}position:absolute;top:50%;line-height:0px;\">{1}</div>")
            public SafeHtml iconWrapper(SafeStyles var1, SafeHtml var2);
        }

        @CssResource.ImportedWithPrefix(value="gwt-ButtonCellBase")
        public static interface Style
        extends CssResource {
            public static final String DEFAULT_CSS = "com/google/gwt/cell/client/ButtonCellBase.css";

            public String buttonCellBase();

            public String buttonCellBaseCollapseLeft();

            public String buttonCellBaseCollapseRight();

            public String buttonCellBaseDefault();

            public String buttonCellBaseNegative();

            public String buttonCellBasePrimary();

            public String buttonCellBasePushing();
        }

        public static interface Resources
        extends ClientBundle {
            @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
            public ImageResource buttonCellBaseBackground();

            @ClientBundle.Source(value={"com/google/gwt/cell/client/ButtonCellBase.css"})
            public Style buttonCellBaseStyle();
        }
    }

    public static enum Decoration {
        DEFAULT,
        PRIMARY,
        NEGATIVE;

    }

    public static interface Appearance<C> {
        public void onPush(Element var1);

        public void onUnpush(Element var1);

        public void render(ButtonCellBase<C> var1, Cell.Context var2, C var3, SafeHtmlBuilder var4);

        public void setFocus(Element var1, boolean var2);
    }
}

