/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.TypeNameObfuscator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StandardSerializationPolicy
extends SerializationPolicy
implements TypeNameObfuscator {
    private final Map<Class<?>, Set<String>> clientFields;
    private final Map<Class<?>, Boolean> deserializationWhitelist;
    private final Map<Class<?>, Boolean> serializationWhitelist;
    private final boolean shouldSerializeFinalFields;
    private final Map<Class<?>, String> typeIds;
    private final Map<String, Class<?>> typeIdsToClasses = new HashMap();

    private static boolean isFieldSerializable(Class<?> clazz, Map<Class<?>, Boolean> whitelist) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return whitelist.containsKey(clazz);
    }

    private static boolean isInstantiable(Class<?> clazz, Map<Class<?>, Boolean> whitelist) {
        if (clazz.isPrimitive()) {
            return true;
        }
        Boolean instantiable = whitelist.get(clazz);
        return instantiable != null && instantiable != false;
    }

    public StandardSerializationPolicy(Map<Class<?>, Boolean> serializationWhitelist, Map<Class<?>, Boolean> deserializationWhitelist, Map<Class<?>, String> obfuscatedTypeIds) {
        this(serializationWhitelist, deserializationWhitelist, obfuscatedTypeIds, null);
    }

    public StandardSerializationPolicy(Map<Class<?>, Boolean> serializationWhitelist, Map<Class<?>, Boolean> deserializationWhitelist, Map<Class<?>, String> obfuscatedTypeIds, Map<Class<?>, Set<String>> clientFields) {
        this(serializationWhitelist, deserializationWhitelist, obfuscatedTypeIds, clientFields, false);
    }

    public StandardSerializationPolicy(Map<Class<?>, Boolean> serializationWhitelist, Map<Class<?>, Boolean> deserializationWhitelist, Map<Class<?>, String> obfuscatedTypeIds, Map<Class<?>, Set<String>> clientFields, boolean shouldSerializeFinalFields) {
        if (serializationWhitelist == null || deserializationWhitelist == null) {
            throw new NullPointerException("whitelist");
        }
        this.serializationWhitelist = serializationWhitelist;
        this.deserializationWhitelist = deserializationWhitelist;
        this.typeIds = obfuscatedTypeIds;
        this.clientFields = clientFields;
        this.shouldSerializeFinalFields = shouldSerializeFinalFields;
        for (Map.Entry<Class<?>, String> entry : obfuscatedTypeIds.entrySet()) {
            assert (entry.getKey() != null) : "null key";
            if (!$assertionsDisabled && entry.getValue() == null) {
                String string = String.valueOf(entry.getKey().getName());
                throw new AssertionError((Object)(string.length() != 0 ? "null value for ".concat(string) : new String("null value for ")));
            }
            if (!$assertionsDisabled && this.typeIdsToClasses.containsKey(entry.getValue())) {
                String string = String.valueOf(entry.getValue());
                throw new AssertionError((Object)(string.length() != 0 ? "Duplicate type id ".concat(string) : new String("Duplicate type id ")));
            }
            this.typeIdsToClasses.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public final String getClassNameForTypeId(String id) throws SerializationException {
        Class<?> clazz = this.typeIdsToClasses.get(id);
        if (clazz == null) {
            return null;
        }
        return clazz.getName();
    }

    @Override
    public Set<String> getClientFieldNamesForEnhancedClass(Class<?> clazz) {
        if (this.clientFields == null) {
            return null;
        }
        Set<String> fieldNames = this.clientFields.get(clazz);
        return fieldNames == null ? null : Collections.unmodifiableSet(fieldNames);
    }

    @Override
    public final String getTypeIdForClass(Class<?> clazz) throws SerializationException {
        return this.typeIds.get(clazz);
    }

    @Override
    public boolean shouldDeserializeFields(Class<?> clazz) {
        return StandardSerializationPolicy.isFieldSerializable(clazz, this.deserializationWhitelist);
    }

    @Override
    public boolean shouldSerializeFields(Class<?> clazz) {
        return StandardSerializationPolicy.isFieldSerializable(clazz, this.serializationWhitelist);
    }

    @Override
    public boolean shouldSerializeFinalFields() {
        return this.shouldSerializeFinalFields;
    }

    @Override
    public void validateDeserialize(Class<?> clazz) throws SerializationException {
        if (!StandardSerializationPolicy.isInstantiable(clazz, this.deserializationWhitelist)) {
            String string = String.valueOf(String.valueOf(clazz.getName()));
            throw new SerializationException(new StringBuilder(198 + string.length()).append("Type '").append(string).append("' was not included in the set of types which can be deserialized by this SerializationPolicy or its Class object could not be loaded. For security purposes, this type will not be deserialized.").toString());
        }
    }

    @Override
    public void validateSerialize(Class<?> clazz) throws SerializationException {
        if (!StandardSerializationPolicy.isInstantiable(clazz, this.serializationWhitelist)) {
            String string = String.valueOf(String.valueOf(clazz.getName()));
            throw new SerializationException(new StringBuilder(194 + string.length()).append("Type '").append(string).append("' was not included in the set of types which can be serialized by this SerializationPolicy or its Class object could not be loaded. For security purposes, this type will not be serialized.").toString());
        }
    }
}

