/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AbstractNativeScrollbar;
import com.google.gwt.user.client.ui.ScrollImpl;
import com.google.gwt.user.client.ui.VerticalScrollbar;

public class NativeVerticalScrollbar
extends AbstractNativeScrollbar
implements VerticalScrollbar {
    private static Resources DEFAULT_RESOURCES;
    private static NativeVerticalScrollbarUiBinder uiBinder;
    @UiField
    Element contentDiv;
    @UiField
    Element scrollable;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public NativeVerticalScrollbar() {
        this(NativeVerticalScrollbar.getDefaultResources());
    }

    public NativeVerticalScrollbar(Resources resources) {
        this.setElement((Element)uiBinder.createAndBindUi(this));
        this.getElement().addClassName(CommonResources.getInlineBlockStyle());
        int n = this.getNativeWidth();
        this.setWidth(new StringBuilder(13).append(n).append("px").toString());
        Style style = resources.nativeVerticalScrollbarStyle();
        style.ensureInjected();
        this.getScrollableElement().addClassName(style.nativeVerticalScrollbar());
        ScrollImpl.get().initialize(this.scrollable, this.contentDiv);
    }

    @Override
    public int getMaximumVerticalScrollPosition() {
        return this.getScrollableElement().getScrollHeight() - this.getElement().getClientHeight();
    }

    @Override
    public int getMinimumVerticalScrollPosition() {
        return 0;
    }

    @Override
    public int getScrollHeight() {
        return this.contentDiv.getOffsetHeight();
    }

    @Override
    public int getVerticalScrollPosition() {
        return this.getScrollableElement().getScrollTop();
    }

    @Override
    public void setScrollHeight(int height) {
        this.contentDiv.getStyle().setHeight(height, Style.Unit.PX);
    }

    @Override
    public void setVerticalScrollPosition(int position) {
        this.getScrollableElement().setScrollTop(position);
    }

    protected int getNativeWidth() {
        return NativeVerticalScrollbar.getNativeScrollbarWidth();
    }

    @Override
    protected Element getScrollableElement() {
        return this.scrollable;
    }

    static {
        uiBinder = (NativeVerticalScrollbarUiBinder)GWT.create(NativeVerticalScrollbarUiBinder.class);
    }

    public static interface StyleTransparant
    extends Style {
        public static final String DEFAULT_CSS = "com/google/gwt/user/client/ui/NativeVerticalScrollbarTransparent.css";
    }

    @CssResource.ImportedWithPrefix(value="gwt-NativeVerticalScrollbar")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/client/ui/NativeVerticalScrollbar.css";

        public String nativeVerticalScrollbar();
    }

    public static interface ResourcesTransparant
    extends Resources {
        @Override
        @ClientBundle.Source(value={"com/google/gwt/user/client/ui/NativeVerticalScrollbarTransparent.css"})
        public Style nativeVerticalScrollbarStyle();
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"com/google/gwt/user/client/ui/NativeVerticalScrollbar.css"})
        public Style nativeVerticalScrollbarStyle();
    }

    static interface NativeVerticalScrollbarUiBinder
    extends UiBinder<Element, NativeVerticalScrollbar> {
    }
}

