/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public class Cookies {
    static HashMap<String, String> cachedCookies = null;
    static String rawCookies;
    private static boolean isCookieEnabled;
    private static boolean isCookieChecked;
    private static boolean uriEncoding;

    public static String getCookie(String name) {
        HashMap<String, String> cookiesMap = Cookies.ensureCookies();
        return (String)cookiesMap.get(name);
    }

    public static Collection<String> getCookieNames() {
        return Cookies.ensureCookies().keySet();
    }

    public static boolean getUriEncode() {
        return uriEncoding;
    }

    public static boolean isCookieEnabled() {
        if (!isCookieChecked) {
            isCookieChecked = true;
            Cookies.setCookie("__gwtCookieCheck", "isEnabled");
            isCookieEnabled = "isEnabled".equals(Cookies.getCookie("__gwtCookieCheck"));
            Cookies.removeCookie("__gwtCookieCheck");
        }
        return isCookieEnabled;
    }

    public static void removeCookie(String name) {
        if (uriEncoding) {
            name = Cookies.uriEncode(name);
        }
        Cookies.removeCookieNative(name);
    }

    public static void removeCookie(String name, String path) {
        if (uriEncoding) {
            name = Cookies.uriEncode(name);
        }
        Cookies.removeCookieNative(name, path);
    }

    public static native void removeCookieNative(String var0, String var1);

    public static void setCookie(String name, String value) {
        Cookies.setCookie(name, value, null, null, null, false);
    }

    public static void setCookie(String name, String value, Date expires) {
        Cookies.setCookie(name, value, expires, null, null, false);
    }

    public static void setCookie(String name, String value, Date expires, String domain, String path, boolean secure) {
        if (uriEncoding) {
            name = Cookies.uriEncode(name);
            value = Cookies.uriEncode(value);
        } else {
            if (!Cookies.isValidCookieName(name)) {
                String string = String.valueOf(String.valueOf(name));
                throw new IllegalArgumentException(new StringBuilder(51 + string.length()).append("Illegal cookie format: ").append(string).append(" is not a valid cookie name.").toString());
            }
            if (!Cookies.isValidCookieValue(value)) {
                String string = String.valueOf(String.valueOf(value));
                throw new IllegalArgumentException(new StringBuilder(52 + string.length()).append("Illegal cookie format: ").append(string).append(" is not a valid cookie value.").toString());
            }
        }
        Cookies.setCookieImpl(name, value, expires == null ? 0.0 : (double)expires.getTime(), domain, path, secure);
    }

    public static void setUriEncode(boolean encode) {
        if (encode != uriEncoding) {
            uriEncoding = encode;
            cachedCookies = null;
        }
    }

    static native void loadCookies(HashMap<String, String> var0);

    private static HashMap<String, String> ensureCookies() {
        if (cachedCookies == null || Cookies.needsRefresh()) {
            HashMap<String, String> newCachedCookies = new HashMap<String, String>();
            Cookies.loadCookies(newCachedCookies);
            cachedCookies = newCachedCookies;
        }
        return cachedCookies;
    }

    private static boolean isValidCookieName(String name) {
        if (uriEncoding) {
            return true;
        }
        return !name.contains("=") && !name.contains(";") && !name.contains(",") && !name.startsWith("$") && !name.matches(".*\\s+.*");
    }

    private static boolean isValidCookieValue(String value) {
        if (uriEncoding) {
            return true;
        }
        return !value.contains("=") && !value.contains(";");
    }

    private static native boolean needsRefresh();

    private static native void removeCookieNative(String var0);

    private static native void setCookieImpl(String var0, String var1, double var2, String var4, String var5, boolean var6);

    private static native String uriEncode(String var0);

    private Cookies() {
    }

    static {
        isCookieEnabled = false;
        isCookieChecked = false;
        uriEncoding = true;
    }
}

