/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.client.LazyDomElement;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class WidgetInterpreter
implements XMLElement.Interpreter<String> {
    private static final Map<String, String> LEGAL_CHILD_ELEMENTS;
    private static final String DEFAULT_CHILD_ELEMENT = "span";
    private final String fieldName;
    private final UiBinderWriter uiWriter;

    private static String getLegalPlaceholderTag(XMLElement elem) {
        XMLElement parent = elem.getParent();
        String tag = null;
        if (parent != null) {
            tag = LEGAL_CHILD_ELEMENTS.get(parent.getLocalName());
        }
        if (tag == null) {
            tag = DEFAULT_CHILD_ELEMENT;
        }
        return tag;
    }

    public WidgetInterpreter(String fieldName, UiBinderWriter writer) {
        this.fieldName = fieldName;
        this.uiWriter = writer;
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        String string;
        if (!this.uiWriter.isWidgetElement(elem)) {
            return null;
        }
        FieldManager fieldManager = this.uiWriter.getFieldManager();
        FieldWriter fieldWriter = fieldManager.require(this.fieldName);
        String idHolder = this.uiWriter.declareDomIdHolder(null);
        this.uiWriter.ensureCurrentFieldAttached();
        FieldWriter childFieldWriter = this.uiWriter.parseElementToField(elem);
        String elementPointer = String.valueOf(idHolder).concat("Element");
        this.uiWriter.addInitStatement("Element %s = com.google.gwt.dom.client.Document.get().getElementById(%s);", new Object[]{elementPointer, idHolder});
        if (this.uiWriter.useLazyWidgetBuilders()) {
            String lazyDomElementPath = LazyDomElement.class.getCanonicalName();
            FieldWriter elementWriter = fieldManager.registerField(lazyDomElementPath, elementPointer);
            elementWriter.setInitializer(String.format("new %s<Element>(%s)", lazyDomElementPath, fieldManager.convertFieldToGetter(idHolder)));
            fieldWriter.addAttachStatement("%s.get();", new Object[]{fieldManager.convertFieldToGetter(elementPointer)});
            fieldWriter.addDetachStatement("%s.addAndReplaceElement(%s, %s.get());", new Object[]{this.fieldName, fieldManager.convertFieldToGetter(childFieldWriter.getName()), fieldManager.convertFieldToGetter(elementPointer)});
        } else {
            this.uiWriter.addDetachStatement("%1$s.addAndReplaceElement(%2$s, %3$s);", new Object[]{this.fieldName, childFieldWriter.getName(), elementPointer});
        }
        String tag = WidgetInterpreter.getLegalPlaceholderTag(elem);
        idHolder = fieldManager.convertFieldToGetter(idHolder);
        if (this.uiWriter.useSafeHtmlTemplates()) {
            idHolder = this.uiWriter.tokenForStringExpression(elem, idHolder);
        } else {
            string = String.valueOf(String.valueOf(idHolder));
            idHolder = new StringBuilder(8 + string.length()).append("\" + ").append(string).append(" + \"").toString();
        }
        string = String.valueOf(String.valueOf(tag));
        String string2 = String.valueOf(String.valueOf(idHolder));
        String string3 = String.valueOf(String.valueOf(tag));
        return new StringBuilder(11 + string.length() + string2.length() + string3.length()).append("<").append(string).append(" id='").append(string2).append("'></").append(string3).append(">").toString();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", "tbody");
        map.put("thead", "tr");
        map.put("tbody", "tr");
        map.put("tfoot", "tr");
        map.put("ul", "li");
        map.put("ol", "li");
        map.put("dl", "dt");
        LEGAL_CHILD_ELEMENTS = Collections.unmodifiableMap(map);
    }
}

