/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safecss.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safecss.shared.SafeStylesHostedModeUtils;
import com.google.gwt.safecss.shared.SafeStylesString;
import com.google.gwt.safehtml.shared.SafeUri;

public final class SafeStylesUtils {
    private static Impl impl;

    public static SafeStyles forBackgroundImage(SafeUri uri) {
        String string = String.valueOf(String.valueOf(uri.asString()));
        return SafeStylesUtils.fromTrustedNameAndValue("background-image", new StringBuilder(7 + string.length()).append("url(\"").append(string).append("\")").toString());
    }

    public static SafeStyles forBorderStyle(Style.BorderStyle value) {
        return SafeStylesUtils.fromTrustedNameAndValue("border-style", value.getCssName());
    }

    public static SafeStyles forBorderWidth(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("border-width", value, unit);
    }

    public static SafeStyles forBottom(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("bottom", value, unit);
    }

    public static SafeStyles forClear(Style.Clear value) {
        return SafeStylesUtils.fromTrustedNameAndValue("clear", value.getCssName());
    }

    public static SafeStyles forCursor(Style.Cursor value) {
        return SafeStylesUtils.fromTrustedNameAndValue("cursor", value.getCssName());
    }

    public static SafeStyles forDisplay(Style.Display value) {
        return SafeStylesUtils.fromTrustedNameAndValue("display", value.getCssName());
    }

    public static SafeStyles forFloat(Style.Float value) {
        return SafeStylesUtils.fromTrustedNameAndValue("float", value.getCssName());
    }

    public static SafeStyles forFontSize(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("font-size", value, unit);
    }

    public static SafeStyles forFontStyle(Style.FontStyle value) {
        return SafeStylesUtils.fromTrustedNameAndValue("font-style", value.getCssName());
    }

    public static SafeStyles forFontWeight(Style.FontWeight value) {
        return SafeStylesUtils.fromTrustedNameAndValue("font-weight", value.getCssName());
    }

    public static SafeStyles forHeight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("height", value, unit);
    }

    public static SafeStyles forLeft(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("left", value, unit);
    }

    public static SafeStyles forLineHeight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("line-height", value, unit);
    }

    public static SafeStyles forListStyleType(Style.ListStyleType value) {
        return SafeStylesUtils.fromTrustedNameAndValue("list-style-type", value.getCssName());
    }

    public static SafeStyles forMargin(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin", value, unit);
    }

    public static SafeStyles forMarginBottom(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-bottom", value, unit);
    }

    public static SafeStyles forMarginLeft(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-left", value, unit);
    }

    public static SafeStyles forMarginRight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-right", value, unit);
    }

    public static SafeStyles forMarginTop(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-top", value, unit);
    }

    public static SafeStyles forOpacity(double value) {
        return SafeStylesUtils.impl().forOpacity(value);
    }

    public static SafeStyles forOutlineStyle(Style.OutlineStyle value) {
        return SafeStylesUtils.fromTrustedNameAndValue("outline-style", value.getCssName());
    }

    public static SafeStyles forOutlineWidth(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("outline-width", value, unit);
    }

    public static SafeStyles forOverflow(Style.Overflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("overflow", value.getCssName());
    }

    public static SafeStyles forOverflowX(Style.Overflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("overflow-x", value.getCssName());
    }

    public static SafeStyles forOverflowY(Style.Overflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("overflow-y", value.getCssName());
    }

    public static SafeStyles forPadding(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding", value, unit);
    }

    public static SafeStyles forPaddingBottom(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-bottom", value, unit);
    }

    public static SafeStyles forPaddingLeft(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-left", value, unit);
    }

    public static SafeStyles forPaddingRight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-right", value, unit);
    }

    public static SafeStyles forPaddingTop(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-top", value, unit);
    }

    public static SafeStyles forPosition(Style.Position value) {
        return SafeStylesUtils.fromTrustedNameAndValue("position", value.getCssName());
    }

    public static SafeStyles forRight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("right", value, unit);
    }

    public static SafeStyles forTableLayout(Style.TableLayout value) {
        return SafeStylesUtils.fromTrustedNameAndValue("table-layout", value.getCssName());
    }

    public static SafeStyles forTextAlign(Style.TextAlign value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-align", value.getCssName());
    }

    public static SafeStyles forTextDecoration(Style.TextDecoration value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-decoration", value.getCssName());
    }

    public static SafeStyles forTextIndent(double value, Style.Unit unit) {
        double d = value;
        String string = String.valueOf(String.valueOf(unit.getType()));
        return SafeStylesUtils.fromTrustedNameAndValue("text-indent", new StringBuilder(24 + string.length()).append(d).append(string).toString());
    }

    public static SafeStyles forTextJustify(Style.TextJustify value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-justify", value.getCssName());
    }

    public static SafeStyles forTextOverflow(Style.TextOverflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-overflow", value.getCssName());
    }

    public static SafeStyles forTextTransform(Style.TextTransform value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-transform", value.getCssName());
    }

    public static SafeStyles forTop(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("top", value, unit);
    }

    public static SafeStyles forTrustedBackgroundColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("background-color", value);
    }

    public static SafeStyles forTrustedBackgroundImage(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("background-image", value);
    }

    public static SafeStyles forTrustedBorderColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("border-color", value);
    }

    public static SafeStyles forTrustedColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("color", value);
    }

    public static SafeStyles forTrustedOutlineColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("outline-color", value);
    }

    public static SafeStyles forVerticalAlign(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("vertical-align", value, unit);
    }

    public static SafeStyles forVerticalAlign(Style.VerticalAlign value) {
        return SafeStylesUtils.fromTrustedNameAndValue("vertical-align", value.getCssName());
    }

    public static SafeStyles forVisibility(Style.Visibility value) {
        return SafeStylesUtils.fromTrustedNameAndValue("visibility", value.getCssName());
    }

    public static SafeStyles forWhiteSpace(Style.WhiteSpace value) {
        return SafeStylesUtils.fromTrustedNameAndValue("white-space", value.getCssName());
    }

    public static SafeStyles forWidth(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("width", value, unit);
    }

    public static SafeStyles forZIndex(int value) {
        int n = value;
        return new SafeStylesString(new StringBuilder(21).append("z-index: ").append(n).append(";").toString());
    }

    public static SafeStyles fromTrustedNameAndValue(String name, double value, Style.Unit unit) {
        SafeStylesHostedModeUtils.maybeCheckValidStyleName(name);
        String string = String.valueOf(String.valueOf(name));
        double d = value;
        String string2 = String.valueOf(String.valueOf(unit.getType()));
        return new SafeStylesString(new StringBuilder(26 + string.length() + string2.length()).append(string).append(":").append(d).append(string2).append(";").toString());
    }

    public static SafeStyles fromTrustedNameAndValue(String name, String value) {
        SafeStylesHostedModeUtils.maybeCheckValidStyleName(name);
        SafeStylesHostedModeUtils.maybeCheckValidStyleValue(value);
        String string = String.valueOf(String.valueOf(name));
        String string2 = String.valueOf(String.valueOf(value));
        return SafeStylesUtils.fromTrustedString(new StringBuilder(2 + string.length() + string2.length()).append(string).append(":").append(string2).append(";").toString());
    }

    public static SafeStyles fromTrustedString(String s) {
        return new SafeStylesString(s);
    }

    static void verifySafeStylesConstraints(String styles) {
        if (styles == null) {
            throw new NullPointerException("css is null");
        }
        if (!$assertionsDisabled && styles.trim().length() != 0 && !styles.endsWith(";")) {
            String string = String.valueOf(String.valueOf(styles));
            throw new AssertionError((Object)new StringBuilder(94 + string.length()).append("Invalid CSS Property: '").append(string).append("'. CSS properties must be an empty string or end with a semi-colon (;).").toString());
        }
        if (!$assertionsDisabled && (styles.contains("<") || styles.contains(">"))) {
            String string = String.valueOf(String.valueOf(styles));
            throw new AssertionError((Object)new StringBuilder(67 + string.length()).append("Invalid CSS Property: '").append(string).append("'. CSS should not contain brackets (< or >).").toString());
        }
    }

    private static Impl impl() {
        if (impl == null) {
            impl = GWT.isClient() ? (Impl)GWT.create(Impl.class) : new ImplServer();
        }
        return impl;
    }

    private SafeStylesUtils() {
    }

    static class ImplIE8
    extends Impl {
        ImplIE8() {
        }

        @Override
        public SafeStyles forOpacity(double value) {
            double d = value * 100.0;
            return new SafeStylesString(new StringBuilder(48).append("filter: alpha(opacity=").append(d).append(");").toString());
        }
    }

    static class ImplServer
    extends Impl {
        private ImplIE8 implIE = new ImplIE8();

        ImplServer() {
        }

        @Override
        public SafeStyles forOpacity(double value) {
            SafeStylesBuilder sb = new SafeStylesBuilder();
            sb.append(super.forOpacity(value));
            sb.append(this.implIE.forOpacity(value));
            return sb.toSafeStyles();
        }
    }

    static class Impl {
        Impl() {
        }

        public SafeStyles forOpacity(double value) {
            double d = value;
            return new SafeStylesString(new StringBuilder(34).append("opacity: ").append(d).append(";").toString());
        }
    }
}

