/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.util.Util;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ResourcePrototype;
import com.google.gwt.resources.converter.Css2Gss;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.ext.SupportsGeneratorResultCaching;
import com.google.gwt.resources.gss.CreateRuntimeConditionalNodes;
import com.google.gwt.resources.gss.CssPrinter;
import com.google.gwt.resources.gss.ExtendedEliminateConditionalNodes;
import com.google.gwt.resources.gss.ExternalClassesCollector;
import com.google.gwt.resources.gss.GwtGssFunctionMapProvider;
import com.google.gwt.resources.gss.ImageSpriteCreator;
import com.google.gwt.resources.gss.PermutationsCollector;
import com.google.gwt.resources.gss.RecordingBidiFlipper;
import com.google.gwt.resources.gss.RenamingSubstitutionMap;
import com.google.gwt.resources.gss.RuntimeConditionalBlockCollector;
import com.google.gwt.resources.gss.ValidateRuntimeConditionalNode;
import com.google.gwt.resources.rg.AbstractCssResourceGenerator;
import com.google.gwt.resources.rg.CssObfuscationStyle;
import com.google.gwt.resources.rg.CssResourceGenerator;
import com.google.gwt.thirdparty.common.css.MinimalSubstitutionMap;
import com.google.gwt.thirdparty.common.css.PrefixingSubstitutionMap;
import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.SubstitutionMap;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunction;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParser;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParserException;
import com.google.gwt.thirdparty.common.css.compiler.passes.AbbreviatePositionalValues;
import com.google.gwt.thirdparty.common.css.compiler.passes.CheckDependencyNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CollectConstantDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.CollectMixinDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.ColorValueOptimizer;
import com.google.gwt.thirdparty.common.css.compiler.passes.ConstantDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateComponentNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateConditionalNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateConstantReferences;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateDefinitionNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateMixins;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateStandardAtRuleNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CssClassRenaming;
import com.google.gwt.thirdparty.common.css.compiler.passes.DisallowDuplicateDeclarations;
import com.google.gwt.thirdparty.common.css.compiler.passes.EliminateEmptyRulesetNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.EliminateUnitsFromZeroNumericValues;
import com.google.gwt.thirdparty.common.css.compiler.passes.EliminateUselessRulesetNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.HandleUnknownAtRuleNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.MarkRemovableRulesetNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.MergeAdjacentRulesetNodesWithSameDeclarations;
import com.google.gwt.thirdparty.common.css.compiler.passes.MergeAdjacentRulesetNodesWithSameSelector;
import com.google.gwt.thirdparty.common.css.compiler.passes.ProcessComponents;
import com.google.gwt.thirdparty.common.css.compiler.passes.ProcessKeyframes;
import com.google.gwt.thirdparty.common.css.compiler.passes.ProcessRefiners;
import com.google.gwt.thirdparty.common.css.compiler.passes.ReplaceConstantReferences;
import com.google.gwt.thirdparty.common.css.compiler.passes.ReplaceMixins;
import com.google.gwt.thirdparty.common.css.compiler.passes.ResolveCustomFunctionNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.SplitRulesetNodes;
import com.google.gwt.thirdparty.guava.common.base.CaseFormat;
import com.google.gwt.thirdparty.guava.common.base.Charsets;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.cache.Cache;
import com.google.gwt.thirdparty.guava.common.cache.CacheBuilder;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.Resources;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.zip.Adler32;
import org.apache.commons.io.IOUtils;

public class GssResourceGenerator
extends AbstractCssResourceGenerator
implements SupportsGeneratorResultCaching {
    private static final Cache<List<URL>, ExtendedCssTree> TREE_CACHE = CacheBuilder.newBuilder().softValues().build();
    private static final Cache<List<URL>, Long> LAST_MODIFIED_CACHE = CacheBuilder.newBuilder().build();
    private static final SubstitutionMap resourcePrefixBuilder = new MinimalSubstitutionMap();
    private static final String KEY_LEGACY = "CssResource.legacy";
    private static final String KEY_CONVERSION_MODE = "CssResource.conversionMode";
    private static final String KEY_STYLE = "CssResource.style";
    private static final String ALLOWED_AT_RULE = "CssResource.allowedAtRules";
    private static final String ALLOWED_FUNCTIONS = "CssResource.allowedFunctions";
    private static final String KEY_OBFUSCATION_PREFIX = "CssResource.obfuscationPrefix";
    private static final String KEY_CLASS_PREFIX = "cssResourcePrefix";
    private static final String KEY_BY_CLASS_AND_METHOD = "cssResourceClassAndMethod";
    private static final String KEY_HAS_CACHED_DATA = "hasCachedData";
    private static final String KEY_SHARED_METHODS = "sharedMethods";
    private static final char[] BASE32_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', '0', '1', '2', '3', '4', '5', '6'};
    private Map<JMethod, ExtendedCssTree> cssTreeMap;
    private Set<String> allowedNonStandardFunctions;
    private LoggerErrorManager errorManager;
    private JMethod getTextMethod;
    private JMethod ensuredInjectedMethod;
    private JMethod getNameMethod;
    private String obfuscationPrefix;
    private CssObfuscationStyle obfuscationStyle;
    private Set<String> allowedAtRules;
    private Map<JClassType, Map<String, String>> replacementsByClassAndMethod;
    private Map<JMethod, String> replacementsForSharedMethods;
    private boolean allowLegacy;
    private boolean lenientConversion;

    public static String getImportPrefix(JClassType importType) {
        String prefix = importType.getSimpleSourceName();
        CssResource.ImportedWithPrefix exp = (CssResource.ImportedWithPrefix)importType.getAnnotation(CssResource.ImportedWithPrefix.class);
        if (exp != null) {
            prefix = exp.value();
        }
        return String.valueOf(prefix).concat("-");
    }

    private static String encode(long id) {
        assert (id >= 0L);
        StringBuilder b = new StringBuilder();
        b.append(BASE32_CHARS[(int)(id & 0xFL)]);
        id >>= 4;
        while (id != 0L) {
            b.append(BASE32_CHARS[(int)(id & 0x1FL)]);
            id >>= 5;
        }
        return b.toString();
    }

    @Override
    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        ExtendedCssTree extendedCssTree = this.cssTreeMap.get(method);
        RenamingResult renamingResult = this.doClassRenaming(extendedCssTree.tree, method, logger, context);
        ConstantDefinitions constantDefinitions = this.optimize(extendedCssTree, context, true, true, logger);
        this.checkErrors();
        Set<String> externalClasses = this.revertRenamingOfExternalClasses(extendedCssTree.tree, renamingResult.mapping);
        this.checkErrors();
        this.validateExternalClasses(externalClasses, renamingResult.externalClassCandidate, method, logger);
        StringSourceWriter sw = new StringSourceWriter();
        String string = String.valueOf(String.valueOf(method.getReturnType().getQualifiedSourceName()));
        sw.println(new StringBuilder(8 + string.length()).append("new ").append(string).append("() {").toString());
        sw.indent();
        this.writeMethods(logger, context, method, (SourceWriter)sw, constantDefinitions, extendedCssTree.originalConstantNameMapping, renamingResult.mapping);
        sw.outdent();
        sw.println("}");
        return sw.toString();
    }

    private void validateExternalClasses(Set<String> externalClasses, Set<String> externalClassCandidates, JMethod method, TreeLogger logger) throws UnableToCompleteException {
        if (!this.isStrictResource(method)) {
            return;
        }
        boolean hasError = false;
        for (String candidate : externalClassCandidates) {
            if (externalClasses.contains(candidate)) continue;
            String string = String.valueOf("The following non-obfuscated class is present in a strict CssResource: ");
            String string2 = String.valueOf(candidate);
            logger.log(TreeLogger.Type.ERROR, string2.length() != 0 ? string.concat(string2) : new String(string));
            hasError = true;
        }
        if (hasError) {
            throw new UnableToCompleteException();
        }
    }

    @Override
    public void init(TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        this.cssTreeMap = new IdentityHashMap<JMethod, ExtendedCssTree>();
        this.errorManager = new LoggerErrorManager(logger);
        this.allowedNonStandardFunctions = new HashSet<String>();
        this.allowedAtRules = Sets.newHashSet("external");
        try {
            PropertyOracle propertyOracle = context.getGeneratorContext().getPropertyOracle();
            ConfigurationProperty styleProp = propertyOracle.getConfigurationProperty(KEY_STYLE);
            this.obfuscationStyle = CssObfuscationStyle.getObfuscationStyle((String)styleProp.getValues().get(0));
            this.obfuscationPrefix = this.getObfuscationPrefix(propertyOracle, context);
            ConfigurationProperty allowedAtRuleProperty = propertyOracle.getConfigurationProperty(ALLOWED_AT_RULE);
            this.allowedAtRules.addAll(allowedAtRuleProperty.getValues());
            ConfigurationProperty allowedFunctionsProperty = propertyOracle.getConfigurationProperty(ALLOWED_FUNCTIONS);
            this.allowedNonStandardFunctions.addAll(allowedFunctionsProperty.getValues());
            this.allowLegacy = "true".equals(propertyOracle.getConfigurationProperty(KEY_LEGACY).getValues().get(0));
            this.lenientConversion = this.allowLegacy && "lenient".equals(propertyOracle.getConfigurationProperty(KEY_CONVERSION_MODE).getValues().get(0));
            ClientBundleRequirements requirements = context.getRequirements();
            requirements.addConfigurationProperty(KEY_STYLE);
            requirements.addConfigurationProperty(KEY_OBFUSCATION_PREFIX);
            requirements.addConfigurationProperty(ALLOWED_AT_RULE);
            requirements.addConfigurationProperty(ALLOWED_FUNCTIONS);
            requirements.addConfigurationProperty(KEY_LEGACY);
            requirements.addConfigurationProperty(KEY_CONVERSION_MODE);
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Unable to query module property", (Throwable)e);
            throw new UnableToCompleteException();
        }
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        JClassType cssResourceInterface = typeOracle.findType(CssResource.class.getCanonicalName());
        JClassType resourcePrototypeInterface = typeOracle.findType(ResourcePrototype.class.getCanonicalName());
        try {
            this.getTextMethod = cssResourceInterface.getMethod("getText", new JType[0]);
            this.ensuredInjectedMethod = cssResourceInterface.getMethod("ensureInjected", new JType[0]);
            this.getNameMethod = resourcePrototypeInterface.getMethod("getName", new JType[0]);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "Unable to lookup methods from CssResource and ResourcePrototype interface", (Throwable)e);
            throw new UnableToCompleteException();
        }
        this.initReplacement(context);
    }

    private void initReplacement(ResourceContext context) {
        if (context.getCachedData(KEY_HAS_CACHED_DATA, Boolean.class) != Boolean.TRUE) {
            context.putCachedData(KEY_SHARED_METHODS, new IdentityHashMap());
            context.putCachedData(KEY_BY_CLASS_AND_METHOD, new IdentityHashMap());
            context.putCachedData(KEY_HAS_CACHED_DATA, Boolean.TRUE);
        }
        this.replacementsByClassAndMethod = context.getCachedData(KEY_BY_CLASS_AND_METHOD, Map.class);
        this.replacementsForSharedMethods = context.getCachedData(KEY_SHARED_METHODS, Map.class);
    }

    private String getObfuscationPrefix(PropertyOracle propertyOracle, ResourceContext context) throws BadPropertyValueException {
        String prefix = (String)propertyOracle.getConfigurationProperty(KEY_OBFUSCATION_PREFIX).getValues().get(0);
        if ("empty".equalsIgnoreCase(prefix)) {
            return "";
        }
        if ("default".equalsIgnoreCase(prefix)) {
            return this.getDefaultObfuscationPrefix(context);
        }
        return prefix;
    }

    private String getDefaultObfuscationPrefix(ResourceContext context) {
        String prefix = context.getCachedData(KEY_CLASS_PREFIX, String.class);
        if (prefix == null) {
            prefix = this.computeDefaultPrefix(context);
            context.putCachedData(KEY_CLASS_PREFIX, prefix);
        }
        return prefix;
    }

    private String computeDefaultPrefix(ResourceContext context) {
        SortedSet<JClassType> gssResources = this.computeOperableTypes(context);
        Adler32 checksum = new Adler32();
        for (JClassType type : gssResources) {
            checksum.update(Util.getBytes((String)type.getQualifiedSourceName()));
        }
        int seed = Math.abs((int)checksum.getValue());
        return String.valueOf(GssResourceGenerator.encode(seed)).concat("-");
    }

    private SortedSet<JClassType> computeOperableTypes(ResourceContext context) {
        JClassType[] cssResourceSubtypes;
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        JClassType baseInterface = typeOracle.findType(CssResource.class.getCanonicalName());
        TreeSet<JClassType> toReturn = new TreeSet<JClassType>(new CssResourceGenerator.JClassOrderComparator());
        for (JClassType type : cssResourceSubtypes = baseInterface.getSubtypes()) {
            if (type.isInterface() == null) continue;
            toReturn.add(type);
        }
        return toReturn;
    }

    @Override
    public void prepare(final TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        ExtendedCssTree extTree;
        if (method.getReturnType().isInterface() == null) {
            logger.log(TreeLogger.ERROR, "Return type must be an interface");
            throw new UnableToCompleteException();
        }
        URL[] resourceUrls = ResourceGeneratorUtil.findResources(logger, context, method);
        if (resourceUrls.length == 0) {
            logger.log(TreeLogger.ERROR, "At least one source must be specified");
            throw new UnableToCompleteException();
        }
        final long lastModified = ResourceGeneratorUtil.getLastModified(resourceUrls, logger);
        final ArrayList<URL> resources = Lists.newArrayList(resourceUrls);
        this.maybeInvalidateCacheFor(resources, lastModified, logger);
        try {
            extTree = TREE_CACHE.get(resources, new Callable<ExtendedCssTree>(){

                @Override
                public ExtendedCssTree call() throws Exception {
                    ExtendedCssTree tree = GssResourceGenerator.this.parseResources(resources, logger);
                    LAST_MODIFIED_CACHE.put(resources, lastModified);
                    return tree;
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnableToCompleteException) {
                throw (UnableToCompleteException)e.getCause();
            }
            logger.log(TreeLogger.Type.ERROR, "Unexpected error occurred", e.getCause());
            throw new UnableToCompleteException();
        }
        ExtendedCssTree finalTree = new ExtendedCssTree(this.deepCopy(extTree.tree), extTree.permutationAxes, extTree.originalConstantNameMapping);
        this.cssTreeMap.put(method, finalTree);
        for (String permutationAxis : extTree.permutationAxes) {
            try {
                context.getRequirements().addPermutationAxis(permutationAxis);
            }
            catch (BadPropertyValueException e) {
                String string = String.valueOf(permutationAxis);
                logger.log(TreeLogger.ERROR, string.length() != 0 ? "Unknown deferred-binding property ".concat(string) : new String("Unknown deferred-binding property "), (Throwable)e);
                throw new UnableToCompleteException();
            }
        }
    }

    @Override
    protected String getCssExpression(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        CssTree cssTree = this.cssTreeMap.get((Object)method).tree;
        String standard = this.printCssTree(cssTree);
        RecordingBidiFlipper recordingBidiFlipper = new RecordingBidiFlipper(cssTree.getMutatingVisitController(), false, false, true);
        recordingBidiFlipper.runPass();
        if (recordingBidiFlipper.nodeFlipped()) {
            String reversed = this.printCssTree(cssTree);
            String string = String.valueOf(String.valueOf(LocaleInfo.class.getName()));
            String string2 = String.valueOf(String.valueOf(reversed));
            String string3 = String.valueOf(String.valueOf(standard));
            return new StringBuilder(33 + string.length() + string2.length() + string3.length()).append(string).append(".getCurrentLocale().isRTL() ? ").append(string2).append(" : ").append(string3).toString();
        }
        return standard;
    }

    private void checkErrors() throws UnableToCompleteException {
        if (this.errorManager.hasErrors()) {
            throw new UnableToCompleteException();
        }
    }

    private CssTree deepCopy(CssTree cssTree) {
        return new CssTree(cssTree.getSourceCode(), cssTree.getRoot().deepCopy());
    }

    private RenamingResult doClassRenaming(CssTree cssTree, JMethod method, TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        Map<String, Map<String, String>> replacementsWithPrefix = this.computeReplacements(method, logger, context);
        RenamingSubstitutionMap substitutionMap = new RenamingSubstitutionMap(replacementsWithPrefix);
        new CssClassRenaming(cssTree.getMutatingVisitController(), (SubstitutionMap)substitutionMap, null).runPass();
        Map<String, String> mapping = replacementsWithPrefix.get("");
        mapping = Maps.newHashMap(Maps.filterKeys(mapping, Predicates.in(substitutionMap.getStyleClasses())));
        return new RenamingResult(mapping, substitutionMap.getExternalClassCandidates());
    }

    private Set<String> revertRenamingOfExternalClasses(CssTree cssTree, Map<String, String> styleClassesMapping) {
        ExternalClassesCollector externalClassesCollector = new ExternalClassesCollector(cssTree.getMutatingVisitController(), this.errorManager);
        externalClassesCollector.runPass();
        Set<String> styleClassSet = styleClassesMapping.keySet();
        Set<String> externalClasses = externalClassesCollector.getExternalClassNames(styleClassSet);
        final HashMap<String, String> revertMap = new HashMap<String, String>(externalClasses.size());
        for (String external : externalClasses) {
            revertMap.put(styleClassesMapping.get(external), external);
            styleClassesMapping.put(external, external);
        }
        SubstitutionMap revertExternalClasses = new SubstitutionMap(){

            public String get(String key) {
                return (String)revertMap.get(key);
            }
        };
        new CssClassRenaming(cssTree.getMutatingVisitController(), revertExternalClasses, null).runPass();
        return externalClasses;
    }

    private boolean isStrictResource(JMethod method) {
        CssResource.NotStrict notStrict = (CssResource.NotStrict)method.getAnnotation(CssResource.NotStrict.class);
        return notStrict == null;
    }

    private List<String> finalizeTree(CssTree cssTree) throws UnableToCompleteException {
        new CheckDependencyNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, false).runPass();
        this.checkErrors();
        new CreateStandardAtRuleNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateMixins(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateDefinitionNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateConstantReferences(cssTree.getMutatingVisitController()).runPass();
        new CreateConditionalNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateRuntimeConditionalNodes(cssTree.getMutatingVisitController()).runPass();
        new CreateComponentNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new HandleUnknownAtRuleNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, this.allowedAtRules, true, false).runPass();
        new ProcessKeyframes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, true, true).runPass();
        new ProcessRefiners(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, true).runPass();
        PermutationsCollector permutationsCollector = new PermutationsCollector(cssTree.getMutatingVisitController(), this.errorManager);
        permutationsCollector.runPass();
        return permutationsCollector.getPermutationAxes();
    }

    private void maybeInvalidateCacheFor(List<URL> resources, long lastModified, TreeLogger logger) {
        Long lastModifiedFromCache = LAST_MODIFIED_CACHE.getIfPresent(resources);
        if (lastModifiedFromCache == null || lastModified == 0L || lastModified > lastModifiedFromCache) {
            TREE_CACHE.invalidate(resources);
        }
    }

    private ConstantDefinitions optimize(ExtendedCssTree extendedCssTree, ResourceContext context, boolean simplifyCss, boolean eliminateDeadStyles, TreeLogger logger) throws UnableToCompleteException {
        CssTree cssTree = extendedCssTree.tree;
        CollectMixinDefinitions collectMixinDefinitions = new CollectMixinDefinitions(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager);
        collectMixinDefinitions.runPass();
        new ReplaceMixins(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, collectMixinDefinitions.getDefinitions()).runPass();
        new ProcessComponents(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        RuntimeConditionalBlockCollector runtimeConditionalBlockCollector = new RuntimeConditionalBlockCollector(cssTree.getVisitController());
        runtimeConditionalBlockCollector.runPass();
        new ExtendedEliminateConditionalNodes(cssTree.getMutatingVisitController(), this.getPermutationsConditions(context, extendedCssTree.permutationAxes, logger), runtimeConditionalBlockCollector.getRuntimeConditionalBlock()).runPass();
        new ValidateRuntimeConditionalNode(cssTree.getVisitController(), this.errorManager, this.lenientConversion).runPass();
        this.checkErrors();
        CollectConstantDefinitions collectConstantDefinitionsPass = new CollectConstantDefinitions(cssTree);
        collectConstantDefinitionsPass.runPass();
        ReplaceConstantReferences replaceConstantReferences = new ReplaceConstantReferences(cssTree, collectConstantDefinitionsPass.getConstantDefinitions(), true, (ErrorManager)this.errorManager, false);
        replaceConstantReferences.runPass();
        new ImageSpriteCreator(cssTree.getMutatingVisitController(), context, this.errorManager).runPass();
        Map<String, GssFunction> gssFunctionMap = new GwtGssFunctionMapProvider(context).get();
        new ResolveCustomFunctionNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, gssFunctionMap, true, this.allowedNonStandardFunctions).runPass();
        if (simplifyCss) {
            new EliminateEmptyRulesetNodes(cssTree.getMutatingVisitController()).runPass();
            new EliminateUnitsFromZeroNumericValues(cssTree.getMutatingVisitController()).runPass();
            new ColorValueOptimizer(cssTree.getMutatingVisitController()).runPass();
            new AbbreviatePositionalValues(cssTree.getMutatingVisitController()).runPass();
        }
        if (eliminateDeadStyles) {
            new DisallowDuplicateDeclarations(cssTree.getVisitController(), (ErrorManager)this.errorManager).runPass();
            new SplitRulesetNodes(cssTree.getMutatingVisitController()).runPass();
            new MarkRemovableRulesetNodes(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
            new MergeAdjacentRulesetNodesWithSameSelector(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
            new MergeAdjacentRulesetNodesWithSameDeclarations(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
        }
        return collectConstantDefinitionsPass.getConstantDefinitions();
    }

    private Set<String> getPermutationsConditions(ResourceContext context, List<String> permutationAxes, TreeLogger logger) throws UnableToCompleteException {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        PropertyOracle oracle = context.getGeneratorContext().getPropertyOracle();
        for (String permutationAxis : permutationAxes) {
            String propValue = null;
            try {
                SelectionProperty selProp = oracle.getSelectionProperty(null, permutationAxis);
                propValue = selProp.getCurrentValue();
            }
            catch (BadPropertyValueException e) {
                try {
                    ConfigurationProperty confProp = oracle.getConfigurationProperty(permutationAxis);
                    propValue = (String)confProp.getValues().get(0);
                }
                catch (BadPropertyValueException e1) {
                    String string = String.valueOf(String.valueOf(permutationAxis));
                    logger.log(TreeLogger.Type.ERROR, new StringBuilder(33 + string.length()).append("Unknown configuration property [").append(string).append("]").toString());
                    throw new UnableToCompleteException();
                }
            }
            if (propValue == null) continue;
            String string = String.valueOf(String.valueOf(permutationAxis));
            String string2 = String.valueOf(String.valueOf(propValue));
            setBuilder.add(new StringBuilder(1 + string.length() + string2.length()).append(string).append(":").append(string2).toString());
        }
        return setBuilder.build();
    }

    private ExtendedCssTree parseResources(List<URL> resources, TreeLogger logger) throws UnableToCompleteException {
        CssTree tree;
        ArrayList<SourceCode> sourceCodes = new ArrayList<SourceCode>(resources.size());
        ImmutableMap.Builder<String, String> constantNameMappingBuilder = ImmutableMap.builder();
        boolean css = this.ensureEitherCssOrGss(resources, logger);
        if (css && !this.allowLegacy) {
            logger.log(TreeLogger.Type.ERROR, "Your ClientBundle is referencing css files instead of gss. You will need to either convert these files to gss using the converter tool or turn on auto convertion in your gwt.xml file. Note: Autoconversion will be removed in the next version of GWT, you will need to move to gss.Add this line to your gwt.xml file to temporary avoid this:<set-configuration-property name=\"CssResource.legacy\" value=\"true\" />");
            throw new UnableToCompleteException();
        }
        if (css) {
            String concatenatedCss = this.concatCssFiles(resources, logger);
            ConversionResult result = this.convertToGss(concatenatedCss, logger);
            String gss = result.gss;
            sourceCodes.add(new SourceCode("[auto-converted gss files]", gss));
            constantNameMappingBuilder.putAll(result.defNameMapping);
        } else {
            for (URL stylesheet : resources) {
                String string = String.valueOf(stylesheet.toExternalForm());
                TreeLogger branchLogger = logger.branch(TreeLogger.DEBUG, string.length() != 0 ? "Parsing GSS stylesheet ".concat(string) : new String("Parsing GSS stylesheet "));
                try {
                    String fileContent = Resources.asByteSource(stylesheet).asCharSource(Charsets.UTF_8).read();
                    sourceCodes.add(new SourceCode(stylesheet.getFile(), fileContent));
                }
                catch (IOException e) {
                    branchLogger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
                    throw new UnableToCompleteException();
                }
            }
        }
        try {
            tree = new GssParser(sourceCodes).parse();
        }
        catch (GssParserException e) {
            logger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
            throw new UnableToCompleteException();
        }
        List<String> permutationAxes = this.finalizeTree(tree);
        this.checkErrors();
        return new ExtendedCssTree(tree, permutationAxes, constantNameMappingBuilder.build());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConversionResult convertToGss(String concatenatedCss, TreeLogger logger) throws UnableToCompleteException {
        ConversionResult conversionResult;
        FileOutputStream fos;
        block9: {
            File tempFile = null;
            fos = null;
            try {
                String string = String.valueOf(String.valueOf(UUID.randomUUID()));
                tempFile = File.createTempFile(new StringBuilder(13 + string.length()).append(string).append("css_converter").toString(), "css.tmp");
                fos = new FileOutputStream(tempFile);
                IOUtils.write((String)concatenatedCss, (OutputStream)fos);
                fos.close();
                Css2Gss converter = new Css2Gss(tempFile.toURI().toURL(), logger, this.lenientConversion);
                conversionResult = new ConversionResult(converter.toGss(), converter.getDefNameMapping());
                if (tempFile == null) break block9;
            }
            catch (Css2GssConversionException e) {
                try {
                    String message;
                    String string = String.valueOf(e.getMessage());
                    String string2 = message = string.length() != 0 ? "An error occurs during the automatic conversion: ".concat(string) : new String("An error occurs during the automatic conversion: ");
                    if (!this.lenientConversion) {
                        message = String.valueOf(message).concat("\n You should try to change the faulty css to fix this error. If you are unable to change the css, you can setup the automatic conversion to be lenient. Add the following line to your gwt.xml file: <set-configuration-property name=\"CssResource.conversionMode\" value=\"lenient\" />");
                    }
                    logger.log(TreeLogger.Type.ERROR, message, (Throwable)e);
                    throw new UnableToCompleteException();
                    catch (IOException e2) {
                        logger.log(TreeLogger.Type.ERROR, "Error while writing temporary css file", (Throwable)e2);
                        throw new UnableToCompleteException();
                    }
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    if (fos != null) {
                        IOUtils.closeQuietly(fos);
                    }
                    throw throwable;
                }
            }
            tempFile.delete();
        }
        if (fos != null) {
            IOUtils.closeQuietly((OutputStream)fos);
        }
        return conversionResult;
    }

    private String concatCssFiles(List<URL> resources, TreeLogger logger) throws UnableToCompleteException {
        StringBuffer buffer = new StringBuffer();
        for (URL stylesheet : resources) {
            try {
                String fileContent = Resources.asByteSource(stylesheet).asCharSource(Charsets.UTF_8).read();
                buffer.append(fileContent);
                buffer.append("\n");
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
                throw new UnableToCompleteException();
            }
        }
        return buffer.toString();
    }

    private boolean ensureEitherCssOrGss(List<URL> resources, TreeLogger logger) throws UnableToCompleteException {
        boolean css = resources.get(0).toString().endsWith(".css");
        for (URL stylesheet : resources) {
            if (css && !stylesheet.toString().endsWith(".css")) {
                logger.log(TreeLogger.Type.ERROR, "Only either css files or gss files are supported on one interface");
                throw new UnableToCompleteException();
            }
            if (css || stylesheet.toString().endsWith(".gss")) continue;
            logger.log(TreeLogger.Type.ERROR, "Only either css files or gss files are supported on one interface");
            throw new UnableToCompleteException();
        }
        return css;
    }

    private String printCssTree(CssTree tree) {
        CssPrinter cssPrinterPass = new CssPrinter(tree);
        cssPrinterPass.runPass();
        return cssPrinterPass.getCompactPrintedString();
    }

    private boolean writeClassMethod(TreeLogger logger, JMethod userMethod, Map<String, String> substitutionMap, SourceWriter sw) throws UnableToCompleteException {
        if (!this.isReturnTypeString(userMethod.getReturnType().isClass())) {
            String string = String.valueOf(String.valueOf(userMethod.getName()));
            logger.log(TreeLogger.Type.ERROR, new StringBuilder(58 + string.length()).append("The return type of the method [").append(string).append("] must ").append("be java.lang.String.").toString());
            throw new UnableToCompleteException();
        }
        if (userMethod.getParameters().length > 0) {
            String string = String.valueOf(String.valueOf(userMethod.getName()));
            logger.log(TreeLogger.Type.ERROR, new StringBuilder(46 + string.length()).append("The method [").append(string).append("] shouldn't contain any ").append("parameters").toString());
            throw new UnableToCompleteException();
        }
        String name = this.getClassName(userMethod);
        String value = substitutionMap.get(name);
        if (value == null) {
            String string = String.valueOf(String.valueOf(name));
            logger.log(TreeLogger.Type.ERROR, new StringBuilder(64 + string.length()).append("The following style class [").append(string).append("] is missing from the source").append(" CSS file").toString());
            return false;
        }
        String string = String.valueOf(String.valueOf(value));
        this.writeSimpleGetter(userMethod, new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString(), sw);
        return true;
    }

    private String getClassName(JMethod method) {
        String name = method.getName();
        CssResource.ClassName classNameOverride = (CssResource.ClassName)method.getAnnotation(CssResource.ClassName.class);
        if (classNameOverride != null) {
            name = classNameOverride.value();
        }
        return name;
    }

    private boolean writeDefMethod(CssDefinitionNode definitionNode, TreeLogger logger, JMethod userMethod, SourceWriter sw) throws UnableToCompleteException {
        String returnExpr;
        String name = userMethod.getName();
        JClassType classReturnType = userMethod.getReturnType().isClass();
        List params = definitionNode.getParameters();
        if (params.size() != 1 && !this.isReturnTypeString(classReturnType)) {
            String string = String.valueOf(String.valueOf(name));
            logger.log(TreeLogger.ERROR, new StringBuilder(70 + string.length()).append("@def rule ").append(string).append(" must define exactly one value or return type must be String").toString());
            return false;
        }
        if (this.isReturnTypeString(classReturnType)) {
            ArrayList<String> returnValues = new ArrayList<String>();
            for (CssValueNode valueNode2 : params) {
                returnValues.add(Generator.escape((String)valueNode2.toString()));
            }
            String i$ = String.valueOf(String.valueOf(Joiner.on(" ").join(returnValues)));
            returnExpr = new StringBuilder(2 + i$.length()).append("\"").append(i$).append("\"").toString();
        } else {
            JPrimitiveType returnType = userMethod.getReturnType().isPrimitive();
            if (returnType == null) {
                String i$ = String.valueOf(String.valueOf(name));
                logger.log(TreeLogger.ERROR, new StringBuilder(65 + i$.length()).append(i$).append(": Return type must be primitive type ").append("or String for @def accessors").toString());
                return false;
            }
            CssValueNode valueNode = (CssValueNode)params.get(0);
            if (!(valueNode instanceof CssNumericNode)) {
                String valueNode2 = String.valueOf(String.valueOf(name));
                logger.log(TreeLogger.ERROR, new StringBuilder(55 + valueNode2.length()).append("The value of the constant defined by @").append(valueNode2).append(" is not a").append(" numeric").toString());
                return false;
            }
            String numericValue = ((CssNumericNode)valueNode).getNumericPart();
            if (returnType == JPrimitiveType.INT || returnType == JPrimitiveType.LONG) {
                long l = Long.parseLong(numericValue);
                returnExpr = new StringBuilder(20).append(l).toString();
            } else if (returnType == JPrimitiveType.FLOAT) {
                returnExpr = String.valueOf(numericValue).concat("F");
            } else if (returnType == JPrimitiveType.DOUBLE) {
                String string = String.valueOf(numericValue);
                returnExpr = string.length() != 0 ? "".concat(string) : new String("");
            } else {
                logger.log(TreeLogger.ERROR, String.valueOf(returnType.getQualifiedSourceName()).concat(" is not a valid primitive return type for @def accessors"));
                return false;
            }
        }
        this.writeSimpleGetter(userMethod, returnExpr, sw);
        return true;
    }

    private void writeMethods(TreeLogger logger, ResourceContext context, JMethod method, SourceWriter sw, ConstantDefinitions constantDefinitions, Map<String, String> originalConstantNameMapping, Map<String, String> substitutionMap) throws UnableToCompleteException {
        JClassType gssResource = method.getReturnType().isInterface();
        boolean success = true;
        for (JMethod toImplement : gssResource.getOverridableMethods()) {
            if (toImplement == this.getTextMethod) {
                this.writeGetText(logger, context, method, sw);
                continue;
            }
            if (toImplement == this.ensuredInjectedMethod) {
                this.writeEnsureInjected(sw);
                continue;
            }
            if (toImplement == this.getNameMethod) {
                this.writeGetName(method, sw);
                continue;
            }
            success &= this.writeUserMethod(logger, toImplement, sw, constantDefinitions, originalConstantNameMapping, substitutionMap);
        }
        if (!success) {
            throw new UnableToCompleteException();
        }
    }

    private boolean writeUserMethod(TreeLogger logger, JMethod userMethod, SourceWriter sw, ConstantDefinitions constantDefinitions, Map<String, String> originalConstantNameMapping, Map<String, String> substitutionMap) throws UnableToCompleteException {
        CssDefinitionNode definitionNode;
        String className = this.getClassName(userMethod);
        if (substitutionMap.containsKey(className)) {
            return this.writeClassMethod(logger, userMethod, substitutionMap, sw);
        }
        String methodName = userMethod.getName();
        if (originalConstantNameMapping.containsKey(methodName)) {
            String constantName = originalConstantNameMapping.get(methodName);
            definitionNode = constantDefinitions.getConstantDefinition(constantName);
        } else {
            definitionNode = constantDefinitions.getConstantDefinition(methodName);
            if (definitionNode == null) {
                definitionNode = constantDefinitions.getConstantDefinition(this.toUpperCase(methodName));
            }
        }
        if (definitionNode != null) {
            return this.writeDefMethod(definitionNode, logger, userMethod, sw);
        }
        String string = String.valueOf(String.valueOf(userMethod.getName()));
        String string2 = String.valueOf(String.valueOf(className));
        logger.log(TreeLogger.Type.ERROR, new StringBuilder(103 + string.length() + string2.length()).append("The following method [").append(string).append("()] doesn't match a constant").append(" nor a style class. You could fix that by adding .").append(string2).append(" {}").toString());
        return false;
    }

    private String toUpperCase(String camelCase) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCase);
    }

    private Map<String, Map<String, String>> computeReplacements(JMethod method, TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        HashMap<String, Map<String, String>> replacementsWithPrefix = new HashMap<String, Map<String, String>>();
        replacementsWithPrefix.put("", this.computeReplacementsForType(method.getReturnType().isInterface()));
        CssResource.Import imp = (CssResource.Import)method.getAnnotation(CssResource.Import.class);
        if (imp != null) {
            boolean fail = false;
            TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
            for (Class<? extends CssResource> clazz : imp.value()) {
                JClassType importType = typeOracle.findType(clazz.getName().replace('$', '.'));
                if (!$assertionsDisabled && importType == null) {
                    String string = String.valueOf(clazz.getName());
                    throw new AssertionError((Object)(string.length() != 0 ? "TypeOracle does not have type ".concat(string) : new String("TypeOracle does not have type ")));
                }
                context.getRequirements().addTypeHierarchy(importType);
                String prefix = GssResourceGenerator.getImportPrefix(importType);
                if (replacementsWithPrefix.put(prefix, this.computeReplacementsForType(importType)) == null) continue;
                String string = String.valueOf(prefix);
                logger.log(TreeLogger.ERROR, string.length() != 0 ? "Multiple imports that would use the prefix ".concat(string) : new String("Multiple imports that would use the prefix "));
                fail = true;
            }
            if (fail) {
                throw new UnableToCompleteException();
            }
        }
        return replacementsWithPrefix;
    }

    private Map<String, String> computeReplacementsForType(JClassType cssResource) {
        Map<String, String> replacements = this.replacementsByClassAndMethod.get(cssResource);
        if (replacements == null) {
            replacements = new HashMap<String, String>();
            this.replacementsByClassAndMethod.put(cssResource, replacements);
            String resourcePrefix = resourcePrefixBuilder.get(cssResource.getQualifiedSourceName());
            String string = String.valueOf(String.valueOf(this.obfuscationPrefix));
            String string2 = String.valueOf(String.valueOf(resourcePrefix));
            PrefixingSubstitutionMap prefixingSubstitutionMap = new PrefixingSubstitutionMap((SubstitutionMap)new MinimalSubstitutionMap(), new StringBuilder(1 + string.length() + string2.length()).append(string).append(string2).append("-").toString());
            for (JMethod method : cssResource.getOverridableMethods()) {
                if (method == this.getNameMethod || method == this.getTextMethod || method == this.ensuredInjectedMethod) continue;
                String styleClass = this.getClassName(method);
                if (this.replacementsForSharedMethods.containsKey(method)) {
                    replacements.put(styleClass, this.replacementsForSharedMethods.get(method));
                    continue;
                }
                String obfuscatedClassName = prefixingSubstitutionMap.get(styleClass);
                String replacement = this.obfuscationStyle.getPrettyName(styleClass, cssResource, obfuscatedClassName);
                replacements.put(styleClass, replacement);
                this.maybeHandleSharedMethod(method, replacement);
            }
        }
        return replacements;
    }

    private void maybeHandleSharedMethod(JMethod method, String obfuscatedClassName) {
        JClassType enclosingType = method.getEnclosingType();
        CssResource.Shared shared = (CssResource.Shared)enclosingType.getAnnotation(CssResource.Shared.class);
        if (shared != null) {
            this.replacementsForSharedMethods.put(method, obfuscatedClassName);
        }
    }

    private static class ExtendedCssTree {
        final CssTree tree;
        final List<String> permutationAxes;
        final Map<String, String> originalConstantNameMapping;

        private ExtendedCssTree(CssTree tree, List<String> permutationAxis, Map<String, String> originalConstantNameMapping) {
            this.tree = tree;
            this.permutationAxes = permutationAxis;
            this.originalConstantNameMapping = originalConstantNameMapping;
        }
    }

    private static class RenamingResult {
        final Map<String, String> mapping;
        final Set<String> externalClassCandidate;

        private RenamingResult(Map<String, String> mapping, Set<String> externalClassCandidate) {
            this.mapping = mapping;
            this.externalClassCandidate = externalClassCandidate;
        }
    }

    private static class ConversionResult {
        final String gss;
        final Map<String, String> defNameMapping;

        private ConversionResult(String gss, Map<String, String> defNameMapping) {
            this.gss = gss;
            this.defNameMapping = defNameMapping;
        }
    }

    private static class LoggerErrorManager
    implements ErrorManager {
        private final TreeLogger logger;
        private boolean hasErrors;

        private LoggerErrorManager(TreeLogger logger) {
            this.logger = logger;
        }

        public void generateReport() {
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public void report(GssError error) {
            String fileName = "";
            String location = "";
            SourceCodeLocation codeLocation = error.getLocation();
            if (codeLocation != null) {
                fileName = codeLocation.getSourceCode().getFileName();
                int n = codeLocation.getBeginLineNumber();
                int n2 = codeLocation.getBeginIndexInLine();
                location = new StringBuilder(39).append("[line: ").append(n).append(" column: ").append(n2).append("]").toString();
            }
            String string = String.valueOf(String.valueOf(fileName));
            String string2 = String.valueOf(String.valueOf(location));
            String string3 = String.valueOf(String.valueOf(error.getMessage()));
            this.logger.log(TreeLogger.Type.ERROR, new StringBuilder(11 + string.length() + string2.length() + string3.length()).append("Error in ").append(string).append(string2).append(": ").append(string3).toString());
            this.hasErrors = true;
        }

        public void reportWarning(GssError warning) {
            this.logger.log(TreeLogger.Type.WARN, warning.getMessage());
        }
    }
}

