/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;

class SimpleError
implements EditorError {
    private final String absolutePath;
    private boolean consumed;
    private final Editor<?> editor;
    private final String message;
    private final Object value;
    private final Object userData;
    private int pathPrefixLength;

    SimpleError(AbstractEditorDelegate<?, ?> delegate, String message, Object value, Object userData) {
        this.absolutePath = delegate.getPath();
        this.editor = delegate.getEditor();
        this.message = message;
        this.value = value == null ? delegate.getObject() : value;
        this.userData = userData;
    }

    SimpleError(AbstractEditorDelegate<?, ?> delegate, String message, Object value, Object userData, String extraPath, Editor<?> leafEditor) {
        assert (extraPath != null && extraPath.length() > 0);
        String string = String.valueOf(delegate.getPath());
        String string2 = String.valueOf(extraPath);
        this.absolutePath = string2.length() != 0 ? string.concat(string2) : new String(string);
        this.editor = leafEditor;
        this.message = message;
        this.value = value;
        this.userData = userData;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public Editor<?> getEditor() {
        return this.editor;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getPath() {
        return this.absolutePath.substring(this.pathPrefixLength);
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.getMessage()));
        String string2 = String.valueOf(String.valueOf(this.getPath()));
        return new StringBuilder(3 + string.length() + string2.length()).append(string).append(" @ ").append(string2).toString();
    }

    void setPathPrefixLength(int pathPrefixLength) {
        this.pathPrefixLength = pathPrefixLength;
    }
}

