/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import java.util.regex.Pattern;

public class Name {
    private static final Pattern NON_TRAILING_DOLLAR = Pattern.compile("[$](\\p{javaJavaIdentifierStart})");
    private static final Pattern NON_TRAILING_DOLLAR_SLASH = Pattern.compile("[$/](\\p{javaJavaIdentifierStart})");

    public static String getBinaryNameForClass(Class<?> clazz) {
        return clazz.getName();
    }

    public static String getInternalNameForClass(Class<?> clazz) {
        return BinaryName.toInternalName(Name.getBinaryNameForClass(clazz));
    }

    public static String getSourceNameForClass(Class<?> clazz) {
        return clazz.getCanonicalName();
    }

    public static boolean isBinaryName(String name) {
        return name == null || !name.contains("/");
    }

    public static boolean isInternalName(String name) {
        return name == null || !name.contains(".");
    }

    public static boolean isSourceName(String name) {
        return name == null || !name.contains("/");
    }

    private Name() {
    }

    public static class SourceOrBinaryName {
        public static String toSourceName(String dottedName) {
            return NON_TRAILING_DOLLAR.matcher(dottedName).replaceAll(".$1");
        }
    }

    public static class SourceName {
        public static String getInnerClassName(String outerClassSourceName, String innerClassShortName) {
            assert (Name.isSourceName(outerClassSourceName));
            String string = String.valueOf(String.valueOf(outerClassSourceName));
            String string2 = String.valueOf(String.valueOf(innerClassShortName));
            return new StringBuilder(1 + string.length() + string2.length()).append(string).append(".").append(string2).toString();
        }

        public static String getShortClassName(String sourceName) {
            assert (Name.isSourceName(sourceName));
            int lastDollar = sourceName.lastIndexOf(46);
            if (lastDollar < 0) {
                return sourceName;
            }
            return sourceName.substring(lastDollar + 1);
        }

        private SourceName() {
        }
    }

    public static class InternalName {
        public static String getClassName(String name) {
            assert (Name.isInternalName(name));
            int lastSlash = name.lastIndexOf(47);
            if (lastSlash < 0) {
                return name;
            }
            return name.substring(lastSlash + 1);
        }

        public static String toBinaryName(String internalName) {
            assert (Name.isInternalName(internalName));
            return internalName.replace('/', '.');
        }

        @Deprecated
        public static String toSourceName(String internalName) {
            assert (Name.isInternalName(internalName));
            return NON_TRAILING_DOLLAR_SLASH.matcher(internalName).replaceAll(".$1");
        }

        private InternalName() {
        }
    }

    public static class BinaryName {
        public static String getClassName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            int lastDot = binaryName.lastIndexOf(46);
            if (lastDot < 0) {
                return binaryName;
            }
            return binaryName.substring(lastDot + 1);
        }

        public static String getShortClassName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            String className = BinaryName.getClassName(binaryName);
            int lastDollar = className.lastIndexOf(36, className.length() - 2);
            if (lastDollar < 0) {
                return className;
            }
            return className.substring(lastDollar + 1);
        }

        public static String toInternalName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            return binaryName.replace('.', '/');
        }

        @Deprecated
        public static String toSourceName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            return NON_TRAILING_DOLLAR.matcher(binaryName).replaceAll(".$1");
        }

        private BinaryName() {
        }
    }
}

