/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

public class TitledPanel
extends SimplePanel {
    private static TitledPanelImpl impl = (TitledPanelImpl)GWT.create(TitledPanelImpl.class);
    private Element legend = DOM.createElement("legend");
    private String caption;

    public TitledPanel(String caption) {
        super(DOM.createElement("fieldset"));
        DOM.appendChild(this.getElement(), this.legend);
        this.setCaption(caption);
    }

    public TitledPanel(String caption, Widget w) {
        this(caption);
        this.setWidget(w);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
        impl.setCaption(this.getElement(), this.legend, caption);
    }

    public static class TitledPanelImplSafari
    extends TitledPanelImpl {
        public void setCaption(final Element fieldset, Element legend, String caption) {
            DOM.setStyleAttribute(fieldset, "visibility", "hidden");
            super.setCaption(fieldset, legend, caption);
            DeferredCommand.addCommand(new Command(){

                public void execute() {
                    DOM.setStyleAttribute(fieldset, "visibility", "");
                }
            });
        }
    }

    public static class TitledPanelImplMozilla
    extends TitledPanelImpl {
        public void setCaption(Element fieldset, Element legend, String caption) {
            DOM.setStyleAttribute(fieldset, "display", "none");
            super.setCaption(fieldset, legend, caption);
            DOM.setStyleAttribute(fieldset, "display", "");
        }
    }

    public static class TitledPanelImpl {
        public void setCaption(Element fieldset, Element legend, String caption) {
            if (caption != "" && caption != null) {
                DOM.setInnerHTML(legend, caption);
                DOM.insertChild(fieldset, legend, 0);
            } else if (DOM.getParent(legend) != null) {
                DOM.removeChild(fieldset, legend);
            }
        }
    }
}

