/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesTabEvents;
import com.google.gwt.user.client.ui.TabListener;
import com.google.gwt.user.client.ui.TabListenerCollection;
import com.google.gwt.user.client.ui.Widget;

public class TabBar
extends Composite
implements SourcesTabEvents,
ClickListener,
KeyboardListener {
    private static final String STYLENAME_DEFAULT = "gwt-TabBarItem";
    private HorizontalPanel panel = new HorizontalPanel();
    private Widget selectedTab;
    private TabListenerCollection tabListeners;

    public TabBar() {
        this.initWidget(this.panel);
        this.sinkEvents(1);
        this.setStyleName("gwt-TabBar");
        Accessibility.setRole(this.panel.getElement(), "tablist");
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        HTML first = new HTML("&nbsp;", true);
        HTML rest = new HTML("&nbsp;", true);
        first.setStyleName("gwt-TabBarFirst");
        rest.setStyleName("gwt-TabBarRest");
        first.setHeight("100%");
        rest.setHeight("100%");
        this.panel.add(first);
        this.panel.add(rest);
        first.setHeight("100%");
        this.panel.setCellHeight(first, "100%");
        this.panel.setCellWidth(rest, "100%");
    }

    public void addTab(String text) {
        this.insertTab(text, this.getTabCount());
    }

    public void addTab(String text, boolean asHTML) {
        this.insertTab(text, asHTML, this.getTabCount());
    }

    public void addTab(Widget widget) {
        this.insertTab(widget, this.getTabCount());
    }

    public void addTabListener(TabListener listener) {
        if (this.tabListeners == null) {
            this.tabListeners = new TabListenerCollection();
        }
        this.tabListeners.add(listener);
    }

    public int getSelectedTab() {
        if (this.selectedTab == null) {
            return -1;
        }
        return this.panel.getWidgetIndex(this.selectedTab) - 1;
    }

    public int getTabCount() {
        return this.panel.getWidgetCount() - 2;
    }

    public String getTabHTML(int index) {
        if (index >= this.getTabCount()) {
            return null;
        }
        ClickDecoratorPanel decPanel = (ClickDecoratorPanel)this.panel.getWidget(index + 1);
        SimplePanel focusablePanel = (SimplePanel)decPanel.getWidget();
        Widget widget = focusablePanel.getWidget();
        if (widget instanceof HTML) {
            return ((HTML)widget).getHTML();
        }
        if (widget instanceof Label) {
            return ((Label)widget).getText();
        }
        return DOM.getInnerHTML(decPanel.getContainerElement());
    }

    public void insertTab(String text, boolean asHTML, int beforeIndex) {
        this.checkInsertBeforeTabIndex(beforeIndex);
        Label item = asHTML ? new HTML(text) : new Label(text);
        item.setWordWrap(false);
        this.insertTabWidget(item, beforeIndex);
    }

    public void insertTab(String text, int beforeIndex) {
        this.insertTab(text, false, beforeIndex);
    }

    public void insertTab(Widget widget, int beforeIndex) {
        this.insertTabWidget(widget, beforeIndex);
    }

    public void onClick(Widget sender) {
        this.selectTabByTabWidget(sender);
    }

    public void onKeyDown(Widget sender, char keyCode, int modifiers) {
        if (keyCode == '\r') {
            this.selectTabByTabWidget(sender);
        }
    }

    public void onKeyPress(Widget sender, char keyCode, int modifiers) {
    }

    public void onKeyUp(Widget sender, char keyCode, int modifiers) {
    }

    public void removeTab(int index) {
        this.checkTabIndex(index);
        Widget toRemove = this.panel.getWidget(index + 1);
        if (toRemove == this.selectedTab) {
            this.selectedTab = null;
        }
        this.panel.remove(toRemove);
    }

    public void removeTabListener(TabListener listener) {
        if (this.tabListeners != null) {
            this.tabListeners.remove(listener);
        }
    }

    public boolean selectTab(int index) {
        this.checkTabIndex(index);
        if (this.tabListeners != null && !this.tabListeners.fireBeforeTabSelected(this, index)) {
            return false;
        }
        this.setSelectionStyle(this.selectedTab, false);
        if (index == -1) {
            this.selectedTab = null;
            return true;
        }
        this.selectedTab = this.panel.getWidget(index + 1);
        this.setSelectionStyle(this.selectedTab, true);
        if (this.tabListeners != null) {
            this.tabListeners.fireTabSelected(this, index);
        }
        return true;
    }

    protected void insertTabWidget(Widget widget, int beforeIndex) {
        this.checkInsertBeforeTabIndex(beforeIndex);
        ClickDecoratorPanel decWidget = new ClickDecoratorPanel(widget, this, this);
        decWidget.setStyleName(STYLENAME_DEFAULT);
        SimplePanel focusablePanel = (SimplePanel)decWidget.getWidget();
        Accessibility.setRole(focusablePanel.getElement(), "tab");
        this.panel.insert(decWidget, beforeIndex + 1);
        TabBar.setStyleName(DOM.getParent(decWidget.getElement()), "gwt-TabBarItem-wrapper", true);
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int numTabs = this.getTabCount();
        for (int i = 0; i < numTabs; ++i) {
            DecoratorPanel decPanel = (DecoratorPanel)this.panel.getWidget(i + 1);
            TabBar.ensureDebugId(decPanel.getContainerElement(), baseID, "tab" + i);
            TabBar.ensureDebugId(DOM.getParent(decPanel.getElement()), baseID, "tab-wrapper" + i);
        }
    }

    private void checkInsertBeforeTabIndex(int beforeIndex) {
        if (beforeIndex < 0 || beforeIndex > this.getTabCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkTabIndex(int index) {
        if (index < -1 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private boolean selectTabByTabWidget(Widget tabWidget) {
        int numTabs = this.panel.getWidgetCount() - 1;
        for (int i = 1; i < numTabs; ++i) {
            if (this.panel.getWidget(i) != tabWidget) continue;
            return this.selectTab(i - 1);
        }
        return false;
    }

    private void setSelectionStyle(Widget item, boolean selected) {
        if (item != null) {
            if (selected) {
                item.addStyleName("gwt-TabBarItem-selected");
                TabBar.setStyleName(DOM.getParent(item.getElement()), "gwt-TabBarItem-wrapper-selected", true);
            } else {
                item.removeStyleName("gwt-TabBarItem-selected");
                TabBar.setStyleName(DOM.getParent(item.getElement()), "gwt-TabBarItem-wrapper-selected", false);
            }
        }
    }

    private static final class ClickDecoratorPanel
    extends DecoratorPanel {
        private static String[] ROW_STYLES = new String[]{"top", "middle"};
        ClickListener clickDelegate;
        KeyboardListener keyDelegate;

        ClickDecoratorPanel(Widget child, ClickListener cDelegate, KeyboardListener kDelegate) {
            super(ROW_STYLES, 1);
            this.clickDelegate = cDelegate;
            this.keyDelegate = kDelegate;
            SimplePanel focusablePanel = new SimplePanel(FocusPanel.impl.createFocusable());
            focusablePanel.setWidget(child);
            this.setWidget(focusablePanel);
            this.sinkEvents(129);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType(event)) {
                case 1: {
                    this.clickDelegate.onClick(this);
                    break;
                }
                case 128: {
                    this.keyDelegate.onKeyDown(this, (char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
                }
            }
        }
    }
}

