/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.animation.WidgetAnimation;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class StackPanel
extends ComplexPanel
implements HasAnimation {
    private static final String DEFAULT_STYLENAME = "gwt-StackPanel";
    private static final String DEFAULT_ITEM_STYLENAME = "gwt-StackPanelItem";
    private static StackAnimation stackAnimation;
    private Element body;
    private boolean isAnimationEnabled = true;
    private int visibleStack = -1;

    public StackPanel() {
        Element table = DOM.createTable();
        this.setElement(table);
        this.body = DOM.createTBody();
        DOM.appendChild(table, this.body);
        DOM.setElementPropertyInt(table, "cellSpacing", 0);
        DOM.setElementPropertyInt(table, "cellPadding", 0);
        DOM.sinkEvents(table, 1);
        this.setStyleName(DEFAULT_STYLENAME);
    }

    public void add(Widget w) {
        this.insert(w, this.getWidgetCount());
    }

    public void add(Widget w, String stackText) {
        this.add(w, stackText, false);
    }

    public void add(Widget w, String stackText, boolean asHTML) {
        this.add(w);
        this.setStackText(this.getWidgetCount() - 1, stackText, asHTML);
    }

    public int getSelectedIndex() {
        return this.visibleStack;
    }

    public void insert(Widget w, int beforeIndex) {
        Element trh = DOM.createTR();
        Element tdh = DOM.createTD();
        DOM.appendChild(trh, tdh);
        DOM.appendChild(tdh, this.createHeaderElem());
        Element trb = DOM.createTR();
        Element tdb = DOM.createTD();
        DOM.appendChild(trb, tdb);
        beforeIndex = this.adjustIndex(w, beforeIndex);
        int effectiveIndex = beforeIndex * 2;
        DOM.insertChild(this.body, trb, effectiveIndex);
        DOM.insertChild(this.body, trh, effectiveIndex);
        StackPanel.setStyleName(tdh, DEFAULT_ITEM_STYLENAME, true);
        DOM.setElementPropertyInt(tdh, "__owner", this.hashCode());
        DOM.setElementProperty(tdh, "height", "1px");
        StackPanel.setStyleName(tdb, "gwt-StackPanelContent", true);
        DOM.setElementProperty(tdb, "height", "100%");
        DOM.setElementProperty(tdb, "vAlign", "top");
        super.insert(w, tdb, beforeIndex, false);
        this.updateIndicesFrom(beforeIndex);
        if (this.visibleStack == -1) {
            this.showStack(0);
        } else {
            this.setStackVisible(beforeIndex, false, true);
            if (this.visibleStack >= beforeIndex) {
                ++this.visibleStack;
            }
            this.setStackVisible(this.visibleStack, true, true);
        }
    }

    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public void onBrowserEvent(Event event) {
        Element target;
        int index;
        if (DOM.eventGetType(event) == 1 && (index = this.findDividerIndex(target = DOM.eventGetTarget(event))) != -1) {
            this.showStack(index);
        }
    }

    public boolean remove(int index) {
        return this.remove(this.getWidget(index), index);
    }

    public boolean remove(Widget child) {
        return this.remove(child, this.getWidgetIndex(child));
    }

    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setStackText(int index, String text) {
        this.setStackText(index, text, false);
    }

    public void setStackText(int index, String text, boolean asHTML) {
        if (index >= this.getWidgetCount()) {
            return;
        }
        Element tdWrapper = DOM.getChild(DOM.getChild(this.body, index * 2), 0);
        Element tbody = DOM.getFirstChild(DOM.getFirstChild(tdWrapper));
        Element tr = DOM.getChild(tbody, 1);
        Element td = DOM.getChild(tr, 1);
        if (asHTML) {
            DOM.setInnerHTML(td, text);
        } else {
            DOM.setInnerText(td, text);
        }
    }

    public void showStack(int index) {
        if (index >= this.getWidgetCount() || index < 0 || index == this.visibleStack) {
            return;
        }
        int oldIndex = this.visibleStack;
        if (this.visibleStack >= 0) {
            this.setStackVisible(this.visibleStack, false, false);
        }
        this.visibleStack = index;
        this.setStackVisible(this.visibleStack, true, false);
        if (stackAnimation == null) {
            stackAnimation = (StackAnimation)GWT.create(StackAnimation.class);
        }
        stackAnimation.showStack(this, oldIndex, index);
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int numHeaders = DOM.getChildCount(this.body) >> 1;
        for (int i = 0; i < numHeaders; ++i) {
            Element headerElem = DOM.getFirstChild(DOM.getChild(this.body, 2 * i));
            Element bodyElem = DOM.getFirstChild(DOM.getChild(this.body, 2 * i + 1));
            StackPanel.ensureDebugId(headerElem, baseID, "text-wrapper" + i);
            StackPanel.ensureDebugId(bodyElem, baseID, "content" + i);
            Element table = DOM.getFirstChild(headerElem);
            Element tbody = DOM.getFirstChild(DOM.getFirstChild(headerElem));
            Element tr = DOM.getChild(tbody, 1);
            Element td = DOM.getChild(tr, 1);
            StackPanel.ensureDebugId(td, baseID, "text" + i);
        }
    }

    private Element createHeaderElem() {
        Element table = DOM.createTable();
        Element tbody = DOM.createTBody();
        DOM.appendChild(table, tbody);
        DOM.setStyleAttribute(table, "width", "100%");
        DOM.setElementPropertyInt(table, "cellSpacing", 0);
        DOM.setElementPropertyInt(table, "cellPadding", 0);
        DOM.appendChild(tbody, DecoratorPanel.createTR("top"));
        DOM.appendChild(tbody, DecoratorPanel.createTR("middle"));
        return table;
    }

    private int findDividerIndex(Element elem) {
        while (elem != this.getElement()) {
            String expando = DOM.getElementProperty(elem, "__index");
            if (expando != null) {
                int ownerHash = DOM.getElementPropertyInt(elem, "__owner");
                if (ownerHash == this.hashCode()) {
                    return Integer.parseInt(expando);
                }
                return -1;
            }
            elem = DOM.getParent(elem);
        }
        return -1;
    }

    private boolean remove(Widget child, int index) {
        boolean removed = super.remove(child);
        if (removed) {
            int rowIndex = 2 * index;
            Element tr = DOM.getChild(this.body, rowIndex);
            DOM.removeChild(this.body, tr);
            tr = DOM.getChild(this.body, rowIndex);
            DOM.removeChild(this.body, tr);
            if (this.visibleStack == index) {
                this.visibleStack = -1;
            } else if (this.visibleStack > index) {
                --this.visibleStack;
            }
            this.updateIndicesFrom(index);
        }
        return removed;
    }

    private void setStackContentVisible(int index, boolean visible) {
        Element tr = DOM.getChild(this.body, index * 2 + 1);
        UIObject.setVisible(tr, visible);
        this.getWidget(index).setVisible(visible);
    }

    private void setStackVisible(int index, boolean visible, boolean render) {
        Element trNext;
        Element tr = DOM.getChild(this.body, index * 2);
        if (tr == null) {
            return;
        }
        Element td = DOM.getFirstChild(tr);
        StackPanel.setStyleName(td, "gwt-StackPanelItem-selected", visible);
        if (render) {
            this.setStackContentVisible(index, visible);
        }
        if ((trNext = DOM.getChild(this.body, (index + 1) * 2)) != null) {
            Element tdNext = DOM.getFirstChild(trNext);
            Element divNext = DOM.getFirstChild(tdNext);
            StackPanel.setStyleName(tdNext, "gwt-StackPanelItem-below-selected", visible);
        }
    }

    private void updateIndicesFrom(int beforeIndex) {
        int c = this.getWidgetCount();
        for (int i = beforeIndex; i < c; ++i) {
            Element childTR = DOM.getChild(this.body, i * 2);
            Element childTD = DOM.getFirstChild(childTR);
            DOM.setElementPropertyInt(childTD, "__index", i);
            if (beforeIndex == 0) {
                StackPanel.setStyleName(childTD, "gwt-StackPanelItem-first", true);
                continue;
            }
            StackPanel.setStyleName(childTD, "gwt-StackPanelItem-first", false);
        }
    }

    public static class StackAnimationIE
    extends StackAnimation {
        protected void clearOpacity(Element elem) {
            DOM.setStyleAttribute(elem, "filter", "");
        }

        protected void setOpacity(Element elem, double opacity) {
            int opac = (int)(100.0 * opacity);
            DOM.setStyleAttribute(elem, "filter", "alpha(opacity=" + opac + ")");
        }
    }

    public static class StackAnimation
    extends WidgetAnimation {
        private StackPanel curPanel = null;
        private int oldIndex = -1;
        private int newIndex = -1;
        private Element newTD = null;

        public void onCancel() {
            this.onComplete();
        }

        public void onComplete() {
            if (this.curPanel != null) {
                this.curPanel.setStackContentVisible(this.oldIndex, false);
                this.curPanel.setStackContentVisible(this.newIndex, true);
                this.clearOpacity(this.newTD);
                this.curPanel = null;
            }
        }

        public void onInstantaneousRun() {
            this.curPanel.setStackContentVisible(this.oldIndex, false);
            this.curPanel.setStackContentVisible(this.newIndex, true);
            this.curPanel = null;
        }

        public void onStart() {
            this.onUpdate(0.0);
            this.curPanel.setStackContentVisible(this.oldIndex, false);
            this.curPanel.setStackContentVisible(this.newIndex, true);
        }

        public void onUpdate(double progress) {
            this.setOpacity(this.newTD, progress);
        }

        public void showStack(StackPanel panel, int oldIndex, int newIndex) {
            this.cancel();
            if (oldIndex < 0) {
                panel.setStackContentVisible(newIndex, true);
                return;
            }
            this.curPanel = panel;
            this.oldIndex = oldIndex;
            this.newIndex = newIndex;
            this.newTD = DOM.getFirstChild(DOM.getChild(this.curPanel.body, 2 * newIndex + 1));
            if (panel.isAnimationEnabled) {
                this.run(250);
            } else {
                this.onInstantaneousRun();
            }
        }

        protected void clearOpacity(Element elem) {
            DOM.setStyleAttribute(elem, "opacity", "");
        }

        protected void setOpacity(Element elem, double opacity) {
            DOM.setStyleAttribute(elem, "opacity", opacity + "");
        }
    }
}

