/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.animation.WidgetAnimation;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupListenerCollection;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesPopupEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.PopupImpl;

public class PopupPanel
extends DecoratorPanel
implements SourcesPopupEvents,
EventPreview,
HasAnimation {
    private static final String DEFAULT_STYLENAME = "gwt-PopupPanel";
    private static final PopupImpl impl = (PopupImpl)GWT.create(PopupImpl.class);
    private static ResizeAnimation resizeAnimation;
    private AnimationType animType = AnimationType.CENTER;
    private boolean autoHide;
    private boolean modal;
    private boolean showing;
    private String desiredHeight;
    private String desiredWidth;
    private boolean isAnimationEnabled = true;
    private int leftPosition = -1;
    private int topPosition = -1;
    private PopupListenerCollection popupListeners;

    public PopupPanel() {
        DOM.appendChild(super.getContainerElement(), impl.createElement());
        this.setPopupPosition(0, 0);
        this.setStyleName(DEFAULT_STYLENAME);
        PopupPanel.setStyleName(this.getContainerElement(), "content");
        DOM.setStyleAttribute(this.getElement(), "overflow", "hidden");
    }

    public PopupPanel(boolean autoHide) {
        this();
        this.autoHide = autoHide;
    }

    public PopupPanel(boolean autoHide, boolean modal) {
        this(autoHide);
        this.modal = modal;
    }

    public void addPopupListener(PopupListener listener) {
        if (this.popupListeners == null) {
            this.popupListeners = new PopupListenerCollection();
        }
        this.popupListeners.add(listener);
    }

    public void center() {
        boolean initiallyShowing = this.showing;
        boolean initiallyAnimated = this.isAnimationEnabled;
        if (!initiallyShowing) {
            this.setVisible(false);
            this.setAnimationEnabled(false);
            this.show();
        }
        int left = Window.getClientWidth() - this.getOffsetWidth() >> 1;
        int top = Window.getClientHeight() - this.getOffsetHeight() >> 1;
        this.setPopupPosition(Window.getScrollLeft() + left, Window.getScrollTop() + top);
        if (!initiallyShowing) {
            this.hide();
            this.setVisible(true);
            this.setAnimationEnabled(initiallyAnimated);
            this.show();
        }
    }

    public int getOffsetHeight() {
        return super.getOffsetHeight();
    }

    public int getOffsetWidth() {
        return super.getOffsetWidth();
    }

    public int getPopupLeft() {
        return DOM.getElementPropertyInt(this.getElement(), "offsetLeft");
    }

    public int getPopupTop() {
        return DOM.getElementPropertyInt(this.getElement(), "offsetTop");
    }

    public String getTitle() {
        return DOM.getElementProperty(this.getContainerElement(), "title");
    }

    public void hide() {
        this.hide(false);
    }

    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public boolean onEventPreview(Event event) {
        Element target = DOM.eventGetTarget(event);
        boolean eventTargetsPopup = target != null && DOM.isOrHasChild(this.getElement(), target);
        int type = DOM.eventGetType(event);
        switch (type) {
            case 128: {
                boolean allow = this.onKeyDownPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
                return allow && (eventTargetsPopup || !this.modal);
            }
            case 512: {
                boolean allow = this.onKeyUpPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
                return allow && (eventTargetsPopup || !this.modal);
            }
            case 256: {
                boolean allow = this.onKeyPressPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
                return allow && (eventTargetsPopup || !this.modal);
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 64: {
                if (DOM.getCaptureElement() != null) {
                    return true;
                }
                if (eventTargetsPopup || !this.autoHide || type != 4) break;
                this.hide(true);
                return true;
            }
            case 2048: {
                if (!this.modal || eventTargetsPopup || target == null) break;
                this.blur(target);
                return false;
            }
        }
        return !this.modal || eventTargetsPopup;
    }

    public boolean onKeyDownPreview(char key, int modifiers) {
        return true;
    }

    public boolean onKeyPressPreview(char key, int modifiers) {
        return true;
    }

    public boolean onKeyUpPreview(char key, int modifiers) {
        return true;
    }

    public void removePopupListener(PopupListener listener) {
        if (this.popupListeners != null) {
            this.popupListeners.remove(listener);
        }
    }

    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setHeight(String height) {
        this.desiredHeight = height;
        this.maybeUpdateSize();
        if (height.length() == 0) {
            this.desiredHeight = null;
        }
    }

    public void setPopupPosition(int left, int top) {
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        this.leftPosition = left;
        this.topPosition = top;
        Element elem = this.getElement();
        DOM.setStyleAttribute(elem, "left", left + "px");
        DOM.setStyleAttribute(elem, "top", top + "px");
    }

    public void setPopupPositionAndShow(PositionCallback callback) {
        this.setVisible(false);
        this.show();
        callback.setPosition(this.getOffsetWidth(), this.getOffsetHeight());
        this.setVisible(true);
    }

    public void setTitle(String title) {
        Element containerElement = this.getContainerElement();
        if (title == null || title.length() == 0) {
            DOM.removeElementAttribute(containerElement, "title");
        } else {
            DOM.setElementAttribute(containerElement, "title", title);
        }
    }

    public void setVisible(boolean visible) {
        DOM.setStyleAttribute(this.getElement(), "visibility", visible ? "visible" : "hidden");
        impl.setVisible(this.getElement(), visible);
    }

    public void setWidget(Widget w) {
        super.setWidget(w);
        this.maybeUpdateSize();
    }

    public void setWidth(String width) {
        this.desiredWidth = width;
        this.maybeUpdateSize();
        if (width.length() == 0) {
            this.desiredWidth = null;
        }
    }

    public void show() {
        if (this.showing) {
            return;
        }
        this.showing = true;
        DOM.addEventPreview(this);
        if (resizeAnimation == null) {
            resizeAnimation = new ResizeAnimation();
        }
        resizeAnimation.setOpen(this);
    }

    protected Element getContainerElement() {
        return impl.getContainerElement(DOM.getFirstChild(super.getContainerElement()));
    }

    protected void onDetach() {
        DOM.removeEventPreview(this);
        super.onDetach();
    }

    protected void setAnimationType(AnimationType type) {
        this.animType = type;
    }

    private native void blur(Element var1);

    private void hide(boolean autoClosed) {
        if (!this.showing) {
            return;
        }
        this.showing = false;
        if (resizeAnimation == null) {
            resizeAnimation = new ResizeAnimation();
        }
        resizeAnimation.setOpen(this);
        if (this.popupListeners != null) {
            this.popupListeners.firePopupClosed(this, autoClosed);
        }
    }

    private void maybeUpdateSize() {
        Widget w = super.getWidget();
        if (w != null) {
            if (this.desiredHeight != null) {
                w.setHeight(this.desiredHeight);
            }
            if (this.desiredWidth != null) {
                w.setWidth(this.desiredWidth);
            }
        }
    }

    public static interface PositionCallback {
        public void setPosition(int var1, int var2);
    }

    private static class ResizeAnimation
    extends WidgetAnimation {
        private int offsetHeight;
        private int offsetWidth = -1;
        private PopupPanel curPanel = null;
        private boolean showing = false;

        private ResizeAnimation() {
        }

        public void onCancel() {
            this.onComplete();
        }

        public void onComplete() {
            if (!this.showing) {
                RootPanel.get().remove(this.curPanel);
                impl.onHide(this.curPanel.getElement());
            }
            impl.setClip(this.curPanel.getElement(), "rect(auto, auto, auto, auto)");
            this.curPanel = null;
        }

        public void onInstantaneousRun() {
            if (this.showing) {
                DOM.setStyleAttribute(this.curPanel.getElement(), "position", "absolute");
                if (this.curPanel.topPosition != -1) {
                    this.curPanel.setPopupPosition(this.curPanel.leftPosition, this.curPanel.topPosition);
                }
                RootPanel.get().add(this.curPanel);
                impl.onShow(this.curPanel.getElement());
            } else {
                RootPanel.get().remove(this.curPanel);
                impl.onHide(this.curPanel.getElement());
            }
            this.curPanel = null;
        }

        public void onStart() {
            if (this.showing) {
                DOM.setStyleAttribute(this.curPanel.getElement(), "position", "absolute");
                if (this.curPanel.topPosition != -1) {
                    this.curPanel.setPopupPosition(this.curPanel.leftPosition, this.curPanel.topPosition);
                }
                impl.setClip(this.curPanel.getElement(), this.getRectString(0, 0, 0, 0));
                RootPanel.get().add(this.curPanel);
                impl.onShow(this.curPanel.getElement());
            }
            this.offsetHeight = this.curPanel.getOffsetHeight();
            this.offsetWidth = this.curPanel.getOffsetWidth();
            this.onUpdate(0.0);
        }

        public void onUpdate(double progress) {
            if (!this.showing) {
                progress = 1.0 - progress;
            }
            int top = 0;
            int left = 0;
            int right = 0;
            int bottom = 0;
            int height = (int)(progress * (double)this.offsetHeight);
            int width = (int)(progress * (double)this.offsetWidth);
            if (this.curPanel.animType == AnimationType.CENTER) {
                top = this.offsetHeight - height >> 1;
                left = this.offsetWidth - width >> 1;
            } else if (this.curPanel.animType == AnimationType.ONE_WAY_CORNER && LocaleInfo.getCurrentLocale().isRTL()) {
                left = this.offsetWidth - width;
            }
            right = left + width;
            bottom = top + height;
            impl.setClip(this.curPanel.getElement(), this.getRectString(top, right, bottom, left));
        }

        public void setOpen(PopupPanel panel) {
            this.cancel();
            boolean animate = panel.isAnimationEnabled;
            if (panel.animType == AnimationType.ONE_WAY_CORNER && !panel.showing) {
                animate = false;
            }
            this.showing = panel.showing;
            this.curPanel = panel;
            if (animate) {
                this.run(200);
            } else {
                this.onInstantaneousRun();
            }
        }

        private String getRectString(int top, int right, int bottom, int left) {
            return "rect(" + top + "px, " + right + "px, " + bottom + "px, " + left + "px)";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnimationType {
        CENTER,
        ONE_WAY_CORNER;

    }
}

