/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

public class DialogBox
extends PopupPanel
implements HasHTML,
HasText,
MouseListener {
    private static final String DEFAULT_STYLENAME = "gwt-DialogBox";
    private HTML caption = new HTML();
    private boolean dragging;
    private int dragStartX;
    private int dragStartY;

    public DialogBox() {
        this(false);
    }

    public DialogBox(boolean autoHide) {
        this(autoHide, true);
    }

    public DialogBox(boolean autoHide, boolean modal) {
        super(autoHide, modal);
        Element td = this.getCellElement(0, 1);
        DOM.appendChild(td, this.caption.getElement());
        this.adopt(this.caption);
        this.caption.setStyleName("Caption");
        this.caption.addMouseListener(this);
        this.setStyleName(DEFAULT_STYLENAME);
    }

    public String getHTML() {
        return this.caption.getHTML();
    }

    public String getText() {
        return this.caption.getText();
    }

    public boolean onEventPreview(Event event) {
        if (DOM.eventGetType(event) == 4 && DOM.isOrHasChild(this.caption.getElement(), DOM.eventGetTarget(event))) {
            DOM.eventPreventDefault(event);
        }
        return super.onEventPreview(event);
    }

    public void onMouseDown(Widget sender, int x, int y) {
        this.dragging = true;
        DOM.setCapture(this.caption.getElement());
        this.dragStartX = x;
        this.dragStartY = y;
    }

    public void onMouseEnter(Widget sender) {
    }

    public void onMouseLeave(Widget sender) {
    }

    public void onMouseMove(Widget sender, int x, int y) {
        if (this.dragging) {
            int absX = x + this.getAbsoluteLeft();
            int absY = y + this.getAbsoluteTop();
            this.setPopupPosition(absX - this.dragStartX, absY - this.dragStartY);
        }
    }

    public void onMouseUp(Widget sender, int x, int y) {
        this.dragging = false;
        DOM.releaseCapture(this.caption.getElement());
    }

    public void setCaptionHTML(String html) {
        this.setHTML(html);
    }

    public void setCaptionText(String text) {
        this.setText(text);
    }

    public void setHTML(String html) {
        this.caption.setHTML(html);
    }

    public void setText(String text) {
        this.caption.setText(text);
    }

    protected void doAttachChildren() {
        super.doAttachChildren();
        this.caption.onAttach();
    }

    protected void doDetachChildren() {
        super.doDetachChildren();
        this.caption.onDetach();
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.caption.ensureDebugId(baseID + "-caption");
        DialogBox.ensureDebugId(this.getContainerElement(), baseID, "content");
    }
}

