/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.HistoryListener;
import com.google.gwt.user.client.impl.HistoryImpl;
import java.util.ArrayList;

public class History {
    private static ArrayList<HistoryListener> historyListeners = new ArrayList();
    private static HistoryImpl impl = (HistoryImpl)GWT.create(HistoryImpl.class);

    public static void addHistoryListener(HistoryListener listener) {
        historyListeners.add(listener);
    }

    public static native void back();

    public static native void forward();

    public static String getToken() {
        return impl != null ? impl.getToken() : "";
    }

    public static void newItem(String historyToken) {
        if (impl != null) {
            impl.newItem(historyToken);
        }
    }

    public static void onHistoryChanged(String historyToken) {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            History.fireHistoryChangedAndCatch(historyToken, handler);
        } else {
            History.fireHistoryChangedImpl(historyToken);
        }
    }

    public static void removeHistoryListener(HistoryListener listener) {
        historyListeners.remove(listener);
    }

    private static void fireHistoryChangedAndCatch(String historyToken, GWT.UncaughtExceptionHandler handler) {
        try {
            History.fireHistoryChangedImpl(historyToken);
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireHistoryChangedImpl(String historyToken) {
        for (HistoryListener listener : historyListeners) {
            listener.onHistoryChanged(historyToken);
        }
    }

    static {
        if (!impl.init()) {
            impl = null;
            GWT.log("Unable to initialize the history subsystem; did you include the history frame in your host page? Try <iframe src=\"javascript:''\" id='__gwt_historyFrame' style='position:absolute;width:0;height:0;border:0'></iframe>", null);
        }
    }
}

