/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Node;
import java.lang.String;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class XPathResult {
  public static double ANY_TYPE;
  public static double ANY_UNORDERED_NODE_TYPE;
  public static double BOOLEAN_TYPE;
  public static double FIRST_ORDERED_NODE_TYPE;
  public static double NUMBER_TYPE;
  public static double ORDERED_NODE_ITERATOR_TYPE;
  public static double ORDERED_NODE_SNAPSHOT_TYPE;
  public static double STRING_TYPE;
  public static double UNORDERED_NODE_ITERATOR_TYPE;
  public static double UNORDERED_NODE_SNAPSHOT_TYPE;
  
  public boolean booleanValue;
  public boolean invalidInteratorState;
  public double numberValue;
  public double resultType;
  public Node singleNodeValue;
  public double snapshotLength;
  public String stringValue;
  
  public native Node iterateNext();

  public native Node snapshotItem(double index);

}
