/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import elemental2.ProgressEvent;
import elemental2.ArrayBuffer;
import elemental2.XMLHttpRequest.OnerrorCallback;
import elemental2.XMLHttpRequest.OnprogressCallback;
import elemental2.XMLHttpRequest.OnreadystatechangeCallback;
import java.lang.String;
import elemental2.Document;
import elemental2.XMLHttpRequestUpload;
import elemental2.XMLHttpRequest.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.XMLHttpRequest.RemoveEventListenerListenerCallback;
import elemental2.ArrayBufferView;
import elemental2.Blob;
import elemental2.FormData;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class XMLHttpRequest implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface OnprogressCallback {
    void onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnreadystatechangeCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public ArrayBuffer mozResponseArrayBuffer;
  public OnerrorCallback onerror;
  public OnprogressCallback onprogress;
  public OnreadystatechangeCallback onreadystatechange;
  public double readyState;
  public /* NativeObject | String */ Object response;
  public String responseText;
  public String responseType;
  public Document responseXML;
  public double status;
  public String statusText;
  public XMLHttpRequestUpload upload;
  public boolean withCredentials;
  
  public native void abort();

  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native boolean dispatchEvent(Event evt);

  public native String getAllResponseHeaders();

  public native String getResponseHeader(String header);

  public native void open(String method, String url, boolean async, String user, String password);

  public native void open(String method, String url);

  public native void open(String method, String url, boolean async);

  public native void open(String method, String url, boolean async, String user);

  public native Object overrideMimeType(String mimeType);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native void send(String data);

  public native void send();

  public native void send(ArrayBuffer data);

  public native void send(ArrayBufferView data);

  public native void send(Blob data);

  public native void send(Document data);

  public native void send(FormData data);

  public native void setRequestHeader(String header, String value);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
