/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import jsinterop.annotations.JsProperty;
import elemental2.WorkerLocation;
import elemental2.WorkerGlobalScope.OnerrorCallback;
import elemental2.WorkerGlobalScope.OnofflineCallback;
import elemental2.WorkerGlobalScope.OnonlineCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface WorkerGlobalScope extends EventTarget {
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnofflineCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnonlineCallback {
    Object onInvoke(Event a);

  }
  Object close();

  @JsProperty
  void setLocation(WorkerLocation location);

  @JsProperty
  WorkerLocation getLocation();

  @JsProperty
  void setOnerror(OnerrorCallback onerror);

  @JsProperty
  OnerrorCallback getOnerror();

  @JsProperty
  void setOnoffline(OnofflineCallback onoffline);

  @JsProperty
  OnofflineCallback getOnoffline();

  @JsProperty
  void setOnonline(OnonlineCallback ononline);

  @JsProperty
  OnonlineCallback getOnonline();

  @JsProperty
  void setSelf(WorkerGlobalScope self);

  @JsProperty
  WorkerGlobalScope getSelf();

}
