/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.IdleDeadline;
import elemental2.Event;
import java.lang.String;
import elemental2.Database;
import elemental2.FileSystem;
import elemental2.FileError;
import elemental2.Entry;
import elemental2.JSONType;
import elemental2.NativeObject;
import elemental2.Arguments;
import elemental2.CacheStorage;
import elemental2.HTMLDocument;
import elemental2.Screen;
import elemental2.SpeechSynthesis;
import elemental2.CSSInterface;
import elemental2.DOMApplicationCache;
import elemental2.History;
import elemental2.IDBFactory;
import elemental2.Storage;
import elemental2.Navigator;
import elemental2.Window.OnabortCallback;
import elemental2.Window.OnbeforeunloadCallback;
import elemental2.Window.OnblurCallback;
import elemental2.Window.OnchangeCallback;
import elemental2.Window.OnclickCallback;
import elemental2.Window.OncloseCallback;
import elemental2.Window.OncontextmenuCallback;
import elemental2.Window.OndblclickCallback;
import elemental2.Window.OndragdropCallback;
import elemental2.Window.OnerrorCallback;
import elemental2.Window.OnfocusCallback;
import elemental2.Window.OnhashchangeCallback;
import elemental2.Window.OnkeydownCallback;
import elemental2.Window.OnkeypressCallback;
import elemental2.Window.OnkeyupCallback;
import elemental2.Window.OnloadCallback;
import elemental2.Window.OnmousedownCallback;
import elemental2.Window.OnmousemoveCallback;
import elemental2.Window.OnmouseoutCallback;
import elemental2.Window.OnmouseoverCallback;
import elemental2.Window.OnmouseupCallback;
import elemental2.Window.OnmousewheelCallback;
import elemental2.Window.OnpaintCallback;
import elemental2.Window.OnpopstateCallback;
import elemental2.Window.OnresetCallback;
import elemental2.Window.OnresizeCallback;
import elemental2.Window.OnscrollCallback;
import elemental2.Window.OnselectCallback;
import elemental2.Window.OnsubmitCallback;
import elemental2.Window.OnunloadCallback;
import elemental2.Window.OnwheelCallback;
import elemental2.Performance;
import elemental2.StorageInfo;
import elemental2.Error;
import elemental2.EvalError;
import elemental2.RangeError;
import elemental2.ReferenceError;
import elemental2.RegExp;
import elemental2.SyntaxError;
import elemental2.TypeError;
import elemental2.URIError;
import elemental2.Window.MozRequestAnimationFrameACallback;
import elemental2.Element;
import elemental2.Window.MsRequestAnimationFrameACallback;
import elemental2.Window.ORequestAnimationFrameACallback;
import elemental2.Transferable;
import elemental2.Window.RequestAnimationFrameACallback;
import elemental2.Window.RequestIdleCallbackACallback;
import elemental2.Window.RequestIdleCallbackBType;
import elemental2.Window.SetImmediateACallback;
import elemental2.Window.SetIntervalACallback;
import elemental2.Window.SetTimeoutACallback;
import elemental2.Window.WebkitRequestAnimationFrameACallback;
import elemental2.Window.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.MediaQueryList;
import elemental2.Window.OpenDatabaseOpt_callback;
import elemental2.DatabaseCallback;
import elemental2.Window.RemoveEventListenerListenerCallback;
import elemental2.Window.RequestFileSystemSuccessCallback;
import elemental2.Window.RequestFileSystemErrorCallback;
import elemental2.Window.ResolveLocalFileSystemURISuccessCallback;
import elemental2.Window.ResolveLocalFileSystemURIErrorCallback;
import elemental2.Window.WebkitRequestFileSystemSuccessCallback;
import elemental2.Window.WebkitRequestFileSystemErrorCallback;
import elemental2.Window.WebkitResolveLocalFileSystemURISuccessCallback;
import elemental2.Window.WebkitResolveLocalFileSystemURIErrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Window implements EventTarget {
  @JsType
  public interface RequestIdleCallbackBType {
    @JsProperty
    void setTimeout(double timeout);

    @JsProperty
    double getTimeout();

  }
  @JsFunction
  public interface MozRequestAnimationFrameACallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface MsRequestAnimationFrameACallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface ORequestAnimationFrameACallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface RequestAnimationFrameACallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface RequestIdleCallbackACallback {
    Object onInvoke(IdleDeadline a);

  }
  @JsFunction
  public interface SetImmediateACallback {
    Object onInvoke();

  }
  @JsFunction
  public interface SetIntervalACallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface SetTimeoutACallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface WebkitRequestAnimationFrameACallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OnabortCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnbeforeunloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnblurCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnchangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnclickCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncloseCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncontextmenuCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndblclickCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndragdropCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(String a, String b, double c);

  }
  @JsFunction
  public interface OnfocusCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnhashchangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeydownCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeypressCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeyupCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousedownCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousemoveCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseoutCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseoverCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseupCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousewheelCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnpaintCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnpopstateCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnresetCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnresizeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnscrollCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnselectCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnsubmitCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnunloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnwheelCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OpenDatabaseOpt_callback {
    Object onInvoke(Database a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface RequestFileSystemSuccessCallback {
    Object onInvoke(FileSystem a);

  }
  @JsFunction
  public interface RequestFileSystemErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface ResolveLocalFileSystemURISuccessCallback {
    Object onInvoke(Entry a);

  }
  @JsFunction
  public interface ResolveLocalFileSystemURIErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface WebkitRequestFileSystemSuccessCallback {
    Object onInvoke(FileSystem a);

  }
  @JsFunction
  public interface WebkitRequestFileSystemErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface WebkitResolveLocalFileSystemURISuccessCallback {
    Object onInvoke(Entry a);

  }
  @JsFunction
  public interface WebkitResolveLocalFileSystemURIErrorCallback {
    Object onInvoke(FileError a);

  }
  public double Infinity;
  public JSONType JSON;
  public Object JavaArray;
  public Object JavaClass;
  public Object JavaMember;
  public Object JavaObject;
  public Object JavaPackage;
  public NativeObject Math;
  public double NaN;
  public Object Packages;
  public NativeObject Reflect;
  public Arguments<Object> arguments;
  public CacheStorage caches;
  public HTMLDocument document;
  public Object dump;
  public Object java;
  public Object netscape;
  public Screen screen;
  public SpeechSynthesis speechSynthesis;
  public Object sun;
  public Object undefined;
  public CSSInterface CSS;
  public double PERSISTENT;
  public double TEMPORARY;
  public DOMApplicationCache applicationCache;
  public boolean closed;
  public /* HTMLObjectElement | HTMLIFrameElement */ Object frameElement;
  public NativeObject frames;
  public History history;
  public IDBFactory indexedDB;
  public double innerHeight;
  public double innerWidth;
  public double length;
  public Storage localStorage;
  public Object location;
  public Object locationbar;
  public Object menubar;
  public IDBFactory mozIndexedDB;
  public IDBFactory moz_indexedDB;
  public IDBFactory msIndexedDB;
  public String name;
  public Navigator navigator;
  public OnabortCallback onabort;
  public OnbeforeunloadCallback onbeforeunload;
  public OnblurCallback onblur;
  public OnchangeCallback onchange;
  public OnclickCallback onclick;
  public OncloseCallback onclose;
  public OncontextmenuCallback oncontextmenu;
  public OndblclickCallback ondblclick;
  public OndragdropCallback ondragdrop;
  public OnerrorCallback onerror;
  public OnfocusCallback onfocus;
  public OnhashchangeCallback onhashchange;
  public OnkeydownCallback onkeydown;
  public OnkeypressCallback onkeypress;
  public OnkeyupCallback onkeyup;
  public OnloadCallback onload;
  public OnmousedownCallback onmousedown;
  public OnmousemoveCallback onmousemove;
  public OnmouseoutCallback onmouseout;
  public OnmouseoverCallback onmouseover;
  public OnmouseupCallback onmouseup;
  public OnmousewheelCallback onmousewheel;
  public OnpaintCallback onpaint;
  public OnpopstateCallback onpopstate;
  public OnresetCallback onreset;
  public OnresizeCallback onresize;
  public OnscrollCallback onscroll;
  public OnselectCallback onselect;
  public OnsubmitCallback onsubmit;
  public OnunloadCallback onunload;
  public OnwheelCallback onwheel;
  public Window opener;
  public double outerHeight;
  public double outerWidth;
  public double pageXOffset;
  public double pageYOffset;
  public Window parent;
  public Performance performance;
  public Object personalbar;
  public double screenX;
  public double screenY;
  public double scrollX;
  public double scrollY;
  public Window self;
  public Storage sessionStorage;
  public String status;
  public Object statusbar;
  public Object toolbar;
  public Window top;
  public IDBFactory webkitIndexedDB;
  public StorageInfo webkitStorageInfo;
  public Window window;
  
  public native Object[] Array(Object... var_args);

  public native boolean Boolean(Object value);

  public native boolean Boolean();

  public native String Date(Object yr_num, Object mo_num, Object day_num, Object hr_num, Object min_num, Object sec_num, Object ms_num);

  public native String Date();

  public native String Date(Object yr_num);

  public native String Date(Object yr_num, Object mo_num);

  public native String Date(Object yr_num, Object mo_num, Object day_num);

  public native String Date(Object yr_num, Object mo_num, Object day_num, Object hr_num);

  public native String Date(Object yr_num, Object mo_num, Object day_num, Object hr_num, Object min_num);

  public native String Date(Object yr_num, Object mo_num, Object day_num, Object hr_num, Object min_num, Object sec_num);

  public native Error Error(Object message, Object file, Object line);

  public native Error Error();

  public native Error Error(Object message);

  public native Error Error(Object message, Object file);

  public native EvalError EvalError(Object message, Object file, Object line);

  public native EvalError EvalError();

  public native EvalError EvalError(Object message);

  public native EvalError EvalError(Object message, Object file);

  public native Object Function(Object... var_args);

  public native double Number(Object value);

  public native double Number();

  public native NativeObject Object(Object value);

  public native NativeObject Object();

  public native RangeError RangeError(Object message, Object file, Object line);

  public native RangeError RangeError();

  public native RangeError RangeError(Object message);

  public native RangeError RangeError(Object message, Object file);

  public native ReferenceError ReferenceError(Object message, Object file, Object line);

  public native ReferenceError ReferenceError();

  public native ReferenceError ReferenceError(Object message);

  public native ReferenceError ReferenceError(Object message, Object file);

  public native RegExp RegExp(Object pattern, Object flags);

  public native RegExp RegExp();

  public native RegExp RegExp(Object pattern);

  public native String ScriptEngine();

  public native double ScriptEngineBuildVersion();

  public native double ScriptEngineMajorVersion();

  public native double ScriptEngineMinorVersion();

  public native String String(Object str);

  public native String String();

  public native Object Symbol(String a);

  public native SyntaxError SyntaxError(Object message, Object file, Object line);

  public native SyntaxError SyntaxError();

  public native SyntaxError SyntaxError(Object message);

  public native SyntaxError SyntaxError(Object message, Object file);

  public native TypeError TypeError(Object message, Object file, Object line);

  public native TypeError TypeError();

  public native TypeError TypeError(Object message);

  public native TypeError TypeError(Object message, Object file);

  public native URIError URIError(Object message, Object file, Object line);

  public native URIError URIError();

  public native URIError URIError(Object message);

  public native URIError URIError(Object message, Object file);

  public native Object cancelAnimationFrame(double a);

  public native Object cancelIdleCallback(double a);

  public native Object cancelRequestAnimationFrame(double a);

  public native Object clearImmediate(double a);

  public native Object clearInterval(double a);

  public native Object clearTimeout(double a);

  public native String decodeURI(String a);

  public native String decodeURIComponent(String a);

  public native String encodeURI(String a);

  public native String encodeURIComponent(String a);

  public native String escape(String a);

  public native Object eval(String a);

  public native boolean hasOwnProperty(Object a);

  public native boolean isFinite(Object a);

  public native boolean isNaN(Object a);

  public native Object mozCancelAnimationFrame(double a);

  public native Object mozCancelRequestAnimationFrame(double a);

  public native double mozRequestAnimationFrame(MozRequestAnimationFrameACallback a, Element b);

  public native double mozRequestAnimationFrame(MozRequestAnimationFrameACallback a);

  public native Object msCancelAnimationFrame(double a);

  public native Object msCancelRequestAnimationFrame(double a);

  public native double msRequestAnimationFrame(MsRequestAnimationFrameACallback a, Element b);

  public native double msRequestAnimationFrame(MsRequestAnimationFrameACallback a);

  public native Object oCancelAnimationFrame(double a);

  public native Object oCancelRequestAnimationFrame(double a);

  public native double oRequestAnimationFrame(ORequestAnimationFrameACallback a, Element b);

  public native double oRequestAnimationFrame(ORequestAnimationFrameACallback a);

  public native double parseFloat(Object a);

  public native double parseInt(Object a, double b);

  public native void postMessage(Object a, Transferable[] b, Object[] c);

  public native void postMessage(Object a);

  public native void postMessage(Object a, String b, Object[] c);

  public native void postMessage(Object a, Transferable[] b);

  public native void postMessage(Object a, String b);

  public native void postMessage(Object a, String b, String c);

  public native void postMessage(Object a, Transferable[] b, String c);

  public native double requestAnimationFrame(RequestAnimationFrameACallback a, Element b);

  public native double requestAnimationFrame(RequestAnimationFrameACallback a);

  public native double requestIdleCallback(RequestIdleCallbackACallback a, RequestIdleCallbackBType b);

  public native double requestIdleCallback(RequestIdleCallbackACallback a);

  public native double requestIdleCallback(RequestIdleCallbackACallback a, double b);

  public native double setImmediate(SetImmediateACallback a);

  public native double setInterval(String a, double b);

  public native double setInterval(SetIntervalACallback a, double b);

  public native double setInterval(String a);

  public native double setInterval(SetIntervalACallback a);

  public native double setTimeout(String a, double b, Object... c);

  public native double setTimeout(SetTimeoutACallback a, double b, Object... c);

  public native double setTimeout(String a);

  public native double setTimeout(SetTimeoutACallback a);

  public native String unescape(String a);

  public native Object webkitCancelAnimationFrame(double a);

  public native Object webkitCancelRequestAnimationFrame(double a);

  public native double webkitRequestAnimationFrame(WebkitRequestAnimationFrameACallback a, Element b);

  public native double webkitRequestAnimationFrame(WebkitRequestAnimationFrameACallback a);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native Object alert(Object message);

  public native Object blur();

  public native Object close();

  public native Object confirm(String message);

  public native Object confirm();

  public native String createObjectURL(NativeObject obj);

  public native boolean dispatchEvent(Event evt);

  public native Object focus();

  public native Object importScripts(String... var_args);

  public native MediaQueryList matchMedia(String media_query_list);

  public native Window open(Object url, String windowName, String windowFeatures, boolean replace);

  public native Window open();

  public native Window open(Object url);

  public native Window open(Object url, String windowName);

  public native Window open(Object url, String windowName, String windowFeatures);

  public native Database openDatabase(String name, String version, String description, double size, OpenDatabaseOpt_callback callback);

  public native Database openDatabase(String name, String version, String description, double size);

  public native Database openDatabase(String name, String version, String description, double size, DatabaseCallback callback);

  public native Object print();

  public native Object prompt(String message, String default_);

  public native Object prompt();

  public native Object prompt(String message);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native Object requestFileSystem(double type, double size, RequestFileSystemSuccessCallback successCallback, RequestFileSystemErrorCallback errorCallback);

  public native Object requestFileSystem(double type, double size, RequestFileSystemSuccessCallback successCallback);

  public native Object resolveLocalFileSystemURI(String uri, ResolveLocalFileSystemURISuccessCallback successCallback, ResolveLocalFileSystemURIErrorCallback errorCallback);

  public native Object resolveLocalFileSystemURI(String uri, ResolveLocalFileSystemURISuccessCallback successCallback);

  public native Object revokeObjectURL(String url);

  public native Object scroll(double x, double y);

  public native Object scrollBy(double x, double y);

  public native Object scrollTo(double x, double y);

  public native Object stop();

  public native Object webkitRequestFileSystem(double type, double size, WebkitRequestFileSystemSuccessCallback successCallback, WebkitRequestFileSystemErrorCallback errorCallback);

  public native Object webkitRequestFileSystem(double type, double size, WebkitRequestFileSystemSuccessCallback successCallback);

  public native Object webkitResolveLocalFileSystemURI(String uri, WebkitResolveLocalFileSystemURISuccessCallback successCallback, WebkitResolveLocalFileSystemURIErrorCallback errorCallback);

  public native Object webkitResolveLocalFileSystemURI(String uri, WebkitResolveLocalFileSystemURISuccessCallback successCallback);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
