/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.MouseEvent;
import jsinterop.annotations.JsProperty;
import elemental2.EventTarget;
import elemental2.Window;
import java.lang.String;
import elemental2.WheelEvent.WheelEvent_InstanceOpt_eventInitDictType;
import elemental2.MouseEvent.MouseEvent_InstanceOpt_eventInitDictType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class WheelEvent extends MouseEvent {
  @JsType
  public interface WheelEvent_InstanceOpt_eventInitDictType {
    @JsProperty
    void setAltKey(boolean altKey);

    @JsProperty
    boolean isAltKey();

    @JsProperty
    void setBubbles(boolean bubbles);

    @JsProperty
    boolean isBubbles();

    @JsProperty
    void setButton(double button);

    @JsProperty
    double getButton();

    @JsProperty
    void setButtons(double buttons);

    @JsProperty
    double getButtons();

    @JsProperty
    void setCancelable(boolean cancelable);

    @JsProperty
    boolean isCancelable();

    @JsProperty
    void setClientX(double clientX);

    @JsProperty
    double getClientX();

    @JsProperty
    void setClientY(double clientY);

    @JsProperty
    double getClientY();

    @JsProperty
    void setCtrlKey(boolean ctrlKey);

    @JsProperty
    boolean isCtrlKey();

    @JsProperty
    void setDeltaMode(double deltaMode);

    @JsProperty
    double getDeltaMode();

    @JsProperty
    void setDeltaX(double deltaX);

    @JsProperty
    double getDeltaX();

    @JsProperty
    void setDeltaY(double deltaY);

    @JsProperty
    double getDeltaY();

    @JsProperty
    void setDeltaZ(double deltaZ);

    @JsProperty
    double getDeltaZ();

    @JsProperty
    void setDetail(double detail);

    @JsProperty
    double getDetail();

    @JsProperty
    void setMetaKey(boolean metaKey);

    @JsProperty
    boolean isMetaKey();

    @JsProperty
    void setRelatedTarget(EventTarget relatedTarget);

    @JsProperty
    EventTarget getRelatedTarget();

    @JsProperty
    void setScreenX(double screenX);

    @JsProperty
    double getScreenX();

    @JsProperty
    void setScreenY(double screenY);

    @JsProperty
    double getScreenY();

    @JsProperty
    void setShiftKey(boolean shiftKey);

    @JsProperty
    boolean isShiftKey();

    @JsProperty
    void setView(Window view);

    @JsProperty
    Window getView();

  }
  public static double DOM_DELTA_LINE;
  public static double DOM_DELTA_PAGE;
  public static double DOM_DELTA_PIXEL;
  
  public double deltaMode;
  public double deltaX;
  public double deltaY;
  public double deltaZ;
  
  public WheelEvent(String type, WheelEvent_InstanceOpt_eventInitDictType eventInitDict) {
    // This call is only there for java compilation purpose.
    super((String) null, (MouseEvent_InstanceOpt_eventInitDictType) null);
  }

  public WheelEvent(String type) {
    // This call is only there for java compilation purpose.
    super((String) null, (MouseEvent_InstanceOpt_eventInitDictType) null);
  }

  
}
