/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import elemental2.MessageEvent;
import java.lang.String;
import elemental2.WebSocket.OncloseCallback;
import elemental2.WebSocket.OnmessageCallback;
import elemental2.WebSocket.OnopenCallback;
import elemental2.WebSocket.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.WebSocket.RemoveEventListenerListenerCallback;
import elemental2.ArrayBufferView;
import elemental2.ArrayBuffer;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class WebSocket implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OncloseCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmessageCallback<Object> {
    Object onInvoke(MessageEvent<Object> a);

  }
  @JsFunction
  public interface OnopenCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public static double CLOSED;
  public static double CLOSING;
  public static double CONNECTING;
  public static double OPEN;
  
  public String binaryType;
  public double bufferedAmount;
  public OncloseCallback onclose;
  public OnmessageCallback onmessage;
  public OnopenCallback onopen;
  public double readyState;
  public String url;
  
  public WebSocket(String url, String protocol) {}

  public WebSocket(String url) {}

  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native Object close(double code, String reason);

  public native Object close();

  public native Object close(double code);

  public native boolean dispatchEvent(Event evt);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native boolean send(ArrayBufferView data);

  public native boolean send(String data);

  public native boolean send(ArrayBuffer data);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
