/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLCanvasElement;
import java.lang.Object;
import elemental2.WebGLProgram;
import elemental2.WebGLShader;
import java.lang.String;
import elemental2.WebGLBuffer;
import elemental2.WebGLFramebuffer;
import elemental2.WebGLRenderbuffer;
import elemental2.WebGLTexture;
import elemental2.ArrayBufferView;
import elemental2.ArrayBuffer;
import elemental2.WebGLActiveInfo;
import elemental2.WebGLContextAttributes;
import elemental2.NativeObject;
import elemental2.WebGLShaderPrecisionFormat;
import elemental2.WebGLUniformLocation;
import elemental2.WebGLObject;
import elemental2.ImageData;
import elemental2.HTMLImageElement;
import elemental2.HTMLVideoElement;
import elemental2.Float32Array;
import elemental2.Int32Array;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class WebGLRenderingContext {
  public static double ACTIVE_ATTRIBUTES;
  public static double ACTIVE_TEXTURE;
  public static double ACTIVE_UNIFORMS;
  public static double ALIASED_LINE_WIDTH_RANGE;
  public static double ALIASED_POINT_SIZE_RANGE;
  public static double ALPHA;
  public static double ALPHA_BITS;
  public static double ALWAYS;
  public static double ARRAY_BUFFER;
  public static double ARRAY_BUFFER_BINDING;
  public static double ATTACHED_SHADERS;
  public static double BACK;
  public static double BLEND;
  public static double BLEND_COLOR;
  public static double BLEND_DST_ALPHA;
  public static double BLEND_DST_RGB;
  public static double BLEND_EQUATION;
  public static double BLEND_EQUATION_ALPHA;
  public static double BLEND_EQUATION_RGB;
  public static double BLEND_SRC_ALPHA;
  public static double BLEND_SRC_RGB;
  public static double BLUE_BITS;
  public static double BOOL;
  public static double BOOL_VEC2;
  public static double BOOL_VEC3;
  public static double BOOL_VEC4;
  public static double BROWSER_DEFAULT_WEBGL;
  public static double BUFFER_SIZE;
  public static double BUFFER_USAGE;
  public static double BYTE;
  public static double CCW;
  public static double CLAMP_TO_EDGE;
  public static double COLOR_ATTACHMENT0;
  public static double COLOR_BUFFER_BIT;
  public static double COLOR_CLEAR_VALUE;
  public static double COLOR_WRITEMASK;
  public static double COMPILE_STATUS;
  public static double COMPRESSED_TEXTURE_FORMATS;
  public static double CONSTANT_ALPHA;
  public static double CONSTANT_COLOR;
  public static double CONTEXT_LOST_WEBGL;
  public static double CULL_FACE;
  public static double CULL_FACE_MODE;
  public static double CURRENT_PROGRAM;
  public static double CURRENT_VERTEX_ATTRIB;
  public static double CW;
  public static double DECR;
  public static double DECR_WRAP;
  public static double DELETE_STATUS;
  public static double DEPTH_ATTACHMENT;
  public static double DEPTH_BITS;
  public static double DEPTH_BUFFER_BIT;
  public static double DEPTH_CLEAR_VALUE;
  public static double DEPTH_COMPONENT;
  public static double DEPTH_COMPONENT16;
  public static double DEPTH_FUNC;
  public static double DEPTH_RANGE;
  public static double DEPTH_STENCIL;
  public static double DEPTH_STENCIL_ATTACHMENT;
  public static double DEPTH_TEST;
  public static double DEPTH_WRITEMASK;
  public static double DITHER;
  public static double DONT_CARE;
  public static double DST_ALPHA;
  public static double DST_COLOR;
  public static double DYNAMIC_DRAW;
  public static double ELEMENT_ARRAY_BUFFER;
  public static double ELEMENT_ARRAY_BUFFER_BINDING;
  public static double EQUAL;
  public static double FASTEST;
  public static double FLOAT;
  public static double FLOAT_MAT2;
  public static double FLOAT_MAT3;
  public static double FLOAT_MAT4;
  public static double FLOAT_VEC2;
  public static double FLOAT_VEC3;
  public static double FLOAT_VEC4;
  public static double FRAGMENT_SHADER;
  public static double FRAMEBUFFER;
  public static double FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
  public static double FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
  public static double FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
  public static double FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
  public static double FRAMEBUFFER_BINDING;
  public static double FRAMEBUFFER_COMPLETE;
  public static double FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
  public static double FRAMEBUFFER_INCOMPLETE_DIMENSIONS;
  public static double FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
  public static double FRAMEBUFFER_UNSUPPORTED;
  public static double FRONT;
  public static double FRONT_AND_BACK;
  public static double FRONT_FACE;
  public static double FUNC_ADD;
  public static double FUNC_REVERSE_SUBTRACT;
  public static double FUNC_SUBTRACT;
  public static double GENERATE_MIPMAP_HINT;
  public static double GEQUAL;
  public static double GREATER;
  public static double GREEN_BITS;
  public static double HIGH_FLOAT;
  public static double HIGH_INT;
  public static double INCR;
  public static double INCR_WRAP;
  public static double INT;
  public static double INT_VEC2;
  public static double INT_VEC3;
  public static double INT_VEC4;
  public static double INVALID_ENUM;
  public static double INVALID_FRAMEBUFFER_OPERATION;
  public static double INVALID_OPERATION;
  public static double INVALID_VALUE;
  public static double INVERT;
  public static double KEEP;
  public static double LEQUAL;
  public static double LESS;
  public static double LINEAR;
  public static double LINEAR_MIPMAP_LINEAR;
  public static double LINEAR_MIPMAP_NEAREST;
  public static double LINES;
  public static double LINE_LOOP;
  public static double LINE_STRIP;
  public static double LINE_WIDTH;
  public static double LINK_STATUS;
  public static double LOW_FLOAT;
  public static double LOW_INT;
  public static double LUMINANCE;
  public static double LUMINANCE_ALPHA;
  public static double MAX_COMBINED_TEXTURE_IMAGE_UNITS;
  public static double MAX_CUBE_MAP_TEXTURE_SIZE;
  public static double MAX_FRAGMENT_UNIFORM_VECTORS;
  public static double MAX_RENDERBUFFER_SIZE;
  public static double MAX_TEXTURE_IMAGE_UNITS;
  public static double MAX_TEXTURE_SIZE;
  public static double MAX_VARYING_VECTORS;
  public static double MAX_VERTEX_ATTRIBS;
  public static double MAX_VERTEX_TEXTURE_IMAGE_UNITS;
  public static double MAX_VERTEX_UNIFORM_VECTORS;
  public static double MAX_VIEWPORT_DIMS;
  public static double MEDIUM_FLOAT;
  public static double MEDIUM_INT;
  public static double MIRRORED_REPEAT;
  public static double NEAREST;
  public static double NEAREST_MIPMAP_LINEAR;
  public static double NEAREST_MIPMAP_NEAREST;
  public static double NEVER;
  public static double NICEST;
  public static double NONE;
  public static double NOTEQUAL;
  public static double NO_ERROR;
  public static double ONE;
  public static double ONE_MINUS_CONSTANT_ALPHA;
  public static double ONE_MINUS_CONSTANT_COLOR;
  public static double ONE_MINUS_DST_ALPHA;
  public static double ONE_MINUS_DST_COLOR;
  public static double ONE_MINUS_SRC_ALPHA;
  public static double ONE_MINUS_SRC_COLOR;
  public static double OUT_OF_MEMORY;
  public static double PACK_ALIGNMENT;
  public static double POINTS;
  public static double POLYGON_OFFSET_FACTOR;
  public static double POLYGON_OFFSET_FILL;
  public static double POLYGON_OFFSET_UNITS;
  public static double RED_BITS;
  public static double RENDERBUFFER;
  public static double RENDERBUFFER_ALPHA_SIZE;
  public static double RENDERBUFFER_BINDING;
  public static double RENDERBUFFER_BLUE_SIZE;
  public static double RENDERBUFFER_DEPTH_SIZE;
  public static double RENDERBUFFER_GREEN_SIZE;
  public static double RENDERBUFFER_HEIGHT;
  public static double RENDERBUFFER_INTERNAL_FORMAT;
  public static double RENDERBUFFER_RED_SIZE;
  public static double RENDERBUFFER_STENCIL_SIZE;
  public static double RENDERBUFFER_WIDTH;
  public static double RENDERER;
  public static double REPEAT;
  public static double REPLACE;
  public static double RGB;
  public static double RGB565;
  public static double RGB5_A1;
  public static double RGBA;
  public static double RGBA4;
  public static double SAMPLER_2D;
  public static double SAMPLER_CUBE;
  public static double SAMPLES;
  public static double SAMPLE_ALPHA_TO_COVERAGE;
  public static double SAMPLE_BUFFERS;
  public static double SAMPLE_COVERAGE;
  public static double SAMPLE_COVERAGE_INVERT;
  public static double SAMPLE_COVERAGE_VALUE;
  public static double SCISSOR_BOX;
  public static double SCISSOR_TEST;
  public static double SHADER_TYPE;
  public static double SHADING_LANGUAGE_VERSION;
  public static double SHORT;
  public static double SRC_ALPHA;
  public static double SRC_ALPHA_SATURATE;
  public static double SRC_COLOR;
  public static double STATIC_DRAW;
  public static double STENCIL_ATTACHMENT;
  public static double STENCIL_BACK_FAIL;
  public static double STENCIL_BACK_FUNC;
  public static double STENCIL_BACK_PASS_DEPTH_FAIL;
  public static double STENCIL_BACK_PASS_DEPTH_PASS;
  public static double STENCIL_BACK_REF;
  public static double STENCIL_BACK_VALUE_MASK;
  public static double STENCIL_BACK_WRITEMASK;
  public static double STENCIL_BITS;
  public static double STENCIL_BUFFER_BIT;
  public static double STENCIL_CLEAR_VALUE;
  public static double STENCIL_FAIL;
  public static double STENCIL_FUNC;
  public static double STENCIL_INDEX;
  public static double STENCIL_INDEX8;
  public static double STENCIL_PASS_DEPTH_FAIL;
  public static double STENCIL_PASS_DEPTH_PASS;
  public static double STENCIL_REF;
  public static double STENCIL_TEST;
  public static double STENCIL_VALUE_MASK;
  public static double STENCIL_WRITEMASK;
  public static double STREAM_DRAW;
  public static double SUBPIXEL_BITS;
  public static double TEXTURE;
  public static double TEXTURE0;
  public static double TEXTURE1;
  public static double TEXTURE10;
  public static double TEXTURE11;
  public static double TEXTURE12;
  public static double TEXTURE13;
  public static double TEXTURE14;
  public static double TEXTURE15;
  public static double TEXTURE16;
  public static double TEXTURE17;
  public static double TEXTURE18;
  public static double TEXTURE19;
  public static double TEXTURE2;
  public static double TEXTURE20;
  public static double TEXTURE21;
  public static double TEXTURE22;
  public static double TEXTURE23;
  public static double TEXTURE24;
  public static double TEXTURE25;
  public static double TEXTURE26;
  public static double TEXTURE27;
  public static double TEXTURE28;
  public static double TEXTURE29;
  public static double TEXTURE3;
  public static double TEXTURE30;
  public static double TEXTURE31;
  public static double TEXTURE4;
  public static double TEXTURE5;
  public static double TEXTURE6;
  public static double TEXTURE7;
  public static double TEXTURE8;
  public static double TEXTURE9;
  public static double TEXTURE_2D;
  public static double TEXTURE_BINDING_2D;
  public static double TEXTURE_BINDING_CUBE_MAP;
  public static double TEXTURE_CUBE_MAP;
  public static double TEXTURE_CUBE_MAP_NEGATIVE_X;
  public static double TEXTURE_CUBE_MAP_NEGATIVE_Y;
  public static double TEXTURE_CUBE_MAP_NEGATIVE_Z;
  public static double TEXTURE_CUBE_MAP_POSITIVE_X;
  public static double TEXTURE_CUBE_MAP_POSITIVE_Y;
  public static double TEXTURE_CUBE_MAP_POSITIVE_Z;
  public static double TEXTURE_MAG_FILTER;
  public static double TEXTURE_MIN_FILTER;
  public static double TEXTURE_WRAP_S;
  public static double TEXTURE_WRAP_T;
  public static double TRIANGLES;
  public static double TRIANGLE_FAN;
  public static double TRIANGLE_STRIP;
  public static double UNPACK_ALIGNMENT;
  public static double UNPACK_COLORSPACE_CONVERSION_WEBGL;
  public static double UNPACK_FLIP_Y_WEBGL;
  public static double UNPACK_PREMULTIPLY_ALPHA_WEBGL;
  public static double UNSIGNED_BYTE;
  public static double UNSIGNED_INT;
  public static double UNSIGNED_SHORT;
  public static double UNSIGNED_SHORT_4_4_4_4;
  public static double UNSIGNED_SHORT_5_5_5_1;
  public static double UNSIGNED_SHORT_5_6_5;
  public static double VALIDATE_STATUS;
  public static double VENDOR;
  public static double VERSION;
  public static double VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
  public static double VERTEX_ATTRIB_ARRAY_ENABLED;
  public static double VERTEX_ATTRIB_ARRAY_NORMALIZED;
  public static double VERTEX_ATTRIB_ARRAY_POINTER;
  public static double VERTEX_ATTRIB_ARRAY_SIZE;
  public static double VERTEX_ATTRIB_ARRAY_STRIDE;
  public static double VERTEX_ATTRIB_ARRAY_TYPE;
  public static double VERTEX_SHADER;
  public static double VIEWPORT;
  public static double ZERO;
  
  public HTMLCanvasElement canvas;
  public double drawingBufferHeight;
  public double drawingBufferWidth;
  
  public native Object activeTexture(double texture);

  public native Object attachShader(WebGLProgram program, WebGLShader shader);

  public native Object bindAttribLocation(WebGLProgram program, double index, String name);

  public native Object bindBuffer(double target, WebGLBuffer buffer);

  public native Object bindFramebuffer(double target, WebGLFramebuffer buffer);

  public native Object bindRenderbuffer(double target, WebGLRenderbuffer buffer);

  public native Object bindTexture(double target, WebGLTexture texture);

  public native Object blendColor(double red, double green, double blue, double alpha);

  public native Object blendEquation(double mode);

  public native Object blendEquationSeparate(double modeRGB, double modeAlpha);

  public native Object blendFunc(double sfactor, double dfactor);

  public native Object blendFuncSeparate(double srcRGB, double dstRGB, double srcAlpha, double dstAlpha);

  public native Object bufferData(double target, double data, double usage);

  public native Object bufferData(double target, ArrayBufferView data, double usage);

  public native Object bufferData(double target, ArrayBuffer data, double usage);

  public native Object bufferSubData(double target, double offset, ArrayBuffer data);

  public native Object bufferSubData(double target, double offset, ArrayBufferView data);

  public native double checkFramebufferStatus(double target);

  public native Object clear(double mask);

  public native Object clearColor(double red, double green, double blue, double alpha);

  public native Object clearDepth(double depth);

  public native Object clearStencil(double s);

  public native Object colorMask(boolean red, boolean green, boolean blue, boolean alpha);

  public native Object compileShader(WebGLShader shader);

  public native Object compressedTexImage2D(double target, double level, double internalformat, double width, double height, double border, ArrayBufferView data);

  public native Object compressedTexSubImage2D(double target, double level, double xoffset, double yoffset, double width, double height, double format, ArrayBufferView data);

  public native Object copyTexImage2D(double target, double level, double format, double x, double y, double width, double height, double border);

  public native Object copyTexSubImage2D(double target, double level, double xoffset, double yoffset, double x, double y, double width, double height);

  public native WebGLBuffer createBuffer();

  public native WebGLFramebuffer createFramebuffer();

  public native WebGLProgram createProgram();

  public native WebGLRenderbuffer createRenderbuffer();

  public native WebGLShader createShader(double type);

  public native WebGLTexture createTexture();

  public native Object cullFace(double mode);

  public native Object deleteBuffer(WebGLBuffer buffer);

  public native Object deleteFramebuffer(WebGLFramebuffer buffer);

  public native Object deleteProgram(WebGLProgram program);

  public native Object deleteRenderbuffer(WebGLRenderbuffer buffer);

  public native Object deleteShader(WebGLShader shader);

  public native Object deleteTexture(WebGLTexture texture);

  public native Object depthFunc(double func);

  public native Object depthMask(boolean flag);

  public native Object depthRange(double nearVal, double farVal);

  public native Object detachShader(WebGLProgram program, WebGLShader shader);

  public native Object disable(double flags);

  public native Object disableVertexAttribArray(double index);

  public native Object drawArrays(double mode, double first, double count);

  public native Object drawElements(double mode, double count, double type, double offset);

  public native Object enable(double cap);

  public native Object enableVertexAttribArray(double index);

  public native Object finish();

  public native Object flush();

  public native Object framebufferRenderbuffer(double target, double attachment, double renderbuffertarget, WebGLRenderbuffer renderbuffer);

  public native Object framebufferTexture2D(double target, double attachment, double textarget, WebGLTexture texture, double level);

  public native Object frontFace(double mode);

  public native Object generateMipmap(double target);

  public native WebGLActiveInfo getActiveAttrib(WebGLProgram program, double index);

  public native WebGLActiveInfo getActiveUniform(WebGLProgram program, double index);

  public native WebGLShader[] getAttachedShaders(WebGLProgram program);

  public native double getAttribLocation(WebGLProgram program, String name);

  public native Object getBufferParameter(double target, double pname);

  public native WebGLContextAttributes getContextAttributes();

  public native double getError();

  public native NativeObject getExtension(String name);

  public native Object getFramebufferAttachmentParameter(double target, double attachment, double pname);

  public native Object getParameter(double pname);

  public native String getProgramInfoLog(WebGLProgram program);

  public native Object getProgramParameter(WebGLProgram program, double pname);

  public native Object getRenderbufferParameter(double target, double pname);

  public native String getShaderInfoLog(WebGLShader shader);

  public native Object getShaderParameter(WebGLShader shader, double pname);

  public native WebGLShaderPrecisionFormat getShaderPrecisionFormat(double shadertype, double precisiontype);

  public native String getShaderSource(WebGLShader shader);

  public native String[] getSupportedExtensions();

  public native Object getTexParameter(double target, double pname);

  public native Object getUniform(WebGLProgram program, WebGLUniformLocation location);

  public native WebGLUniformLocation getUniformLocation(WebGLProgram program, String name);

  public native Object getVertexAttrib(double index, double pname);

  public native double getVertexAttribOffset(double index, double pname);

  public native Object hint(double target, double mode);

  public native boolean isBuffer(WebGLObject buffer);

  public native boolean isContextLost();

  public native boolean isEnabled(double cap);

  public native boolean isFramebuffer(WebGLObject framebuffer);

  public native boolean isProgram(WebGLObject program);

  public native boolean isRenderbuffer(WebGLObject renderbuffer);

  public native boolean isShader(WebGLObject shader);

  public native boolean isTexture(WebGLObject texture);

  public native Object lineWidth(double width);

  public native Object linkProgram(WebGLProgram program);

  public native Object pixelStorei(double pname, double param);

  public native Object polygonOffset(double factor, double units);

  public native Object readPixels(double x, double y, double width, double height, double format, double type, ArrayBufferView pixels);

  public native Object renderbufferStorage(double target, double internalformat, double width, double height);

  public native Object sampleCoverage(double coverage, boolean invert);

  public native Object scissor(double x, double y, double width, double height);

  public native Object shaderSource(WebGLShader shader, String source);

  public native Object stencilFunc(double func, double ref, double mask);

  public native Object stencilFuncSeparate(double face, double func, double ref, double mask);

  public native Object stencilMask(double mask);

  public native Object stencilMaskSeparate(double face, double mask);

  public native Object stencilOp(double fail, double zfail, double zpass);

  public native Object stencilOpSeparate(double face, double fail, double zfail, double zpass);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, double img, double format0, double type0, ArrayBufferView pixels);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, ImageData img, double format0, double type0, ArrayBufferView pixels);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLImageElement img, double format0, double type0, ArrayBufferView pixels);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLCanvasElement img, double format0, double type0, ArrayBufferView pixels);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLVideoElement img, double format0, double type0, ArrayBufferView pixels);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, double img);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, ImageData img);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLImageElement img);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLCanvasElement img);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLVideoElement img);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, double img, double format0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, ImageData img, double format0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLImageElement img, double format0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLCanvasElement img, double format0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLVideoElement img, double format0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, double img, double format0, double type0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, ImageData img, double format0, double type0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLImageElement img, double format0, double type0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLCanvasElement img, double format0, double type0);

  public native Object texImage2D(double target, double level, double internalformat, double format, double type, HTMLVideoElement img, double format0, double type0);

  public native Object texParameterf(double target, double pname, double param);

  public native Object texParameteri(double target, double pname, double param);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, double data, double type0, ArrayBufferView pixels);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, ImageData data, double type0, ArrayBufferView pixels);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLImageElement data, double type0, ArrayBufferView pixels);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLCanvasElement data, double type0, ArrayBufferView pixels);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLVideoElement data, double type0, ArrayBufferView pixels);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, double data);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, ImageData data);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLImageElement data);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLCanvasElement data);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLVideoElement data);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, double data, double type0);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, ImageData data, double type0);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLImageElement data, double type0);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLCanvasElement data, double type0);

  public native Object texSubImage2D(double target, double level, double xoffset, double yoffset, double format, double type, HTMLVideoElement data, double type0);

  public native Object uniform1f(WebGLUniformLocation location, double value);

  public native Object uniform1fv(WebGLUniformLocation location, double[] value);

  public native Object uniform1fv(WebGLUniformLocation location, Float32Array value);

  public native Object uniform1i(WebGLUniformLocation location, boolean value);

  public native Object uniform1i(WebGLUniformLocation location, double value);

  public native Object uniform1iv(WebGLUniformLocation location, Object[] value);

  public native Object uniform1iv(WebGLUniformLocation location, Int32Array value);

  public native Object uniform2f(WebGLUniformLocation location, double value1, double value2);

  public native Object uniform2fv(WebGLUniformLocation location, double[] value);

  public native Object uniform2fv(WebGLUniformLocation location, Float32Array value);

  public native Object uniform2i(WebGLUniformLocation location, boolean value1, boolean value2);

  public native Object uniform2i(WebGLUniformLocation location, double value1, boolean value2);

  public native Object uniform2i(WebGLUniformLocation location, double value1, double value2);

  public native Object uniform2i(WebGLUniformLocation location, boolean value1, double value2);

  public native Object uniform2iv(WebGLUniformLocation location, Object[] value);

  public native Object uniform2iv(WebGLUniformLocation location, Int32Array value);

  public native Object uniform3f(WebGLUniformLocation location, double value1, double value2, double value3);

  public native Object uniform3fv(WebGLUniformLocation location, double[] value);

  public native Object uniform3fv(WebGLUniformLocation location, Float32Array value);

  public native Object uniform3i(WebGLUniformLocation location, boolean value1, boolean value2, boolean value3);

  public native Object uniform3i(WebGLUniformLocation location, double value1, boolean value2, boolean value3);

  public native Object uniform3i(WebGLUniformLocation location, double value1, double value2, boolean value3);

  public native Object uniform3i(WebGLUniformLocation location, boolean value1, double value2, boolean value3);

  public native Object uniform3i(WebGLUniformLocation location, boolean value1, double value2, double value3);

  public native Object uniform3i(WebGLUniformLocation location, double value1, double value2, double value3);

  public native Object uniform3i(WebGLUniformLocation location, double value1, boolean value2, double value3);

  public native Object uniform3i(WebGLUniformLocation location, boolean value1, boolean value2, double value3);

  public native Object uniform3iv(WebGLUniformLocation location, Object[] value);

  public native Object uniform3iv(WebGLUniformLocation location, Int32Array value);

  public native Object uniform4f(WebGLUniformLocation location, double value1, double value2, double value3, double value4);

  public native Object uniform4fv(WebGLUniformLocation location, double[] value);

  public native Object uniform4fv(WebGLUniformLocation location, Float32Array value);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, boolean value2, boolean value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, boolean value2, boolean value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, double value2, boolean value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, double value2, boolean value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, double value2, double value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, double value2, double value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, boolean value2, double value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, boolean value2, double value3, boolean value4);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, boolean value2, double value3, double value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, boolean value2, double value3, double value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, double value2, double value3, double value4);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, double value2, double value3, double value4);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, double value2, boolean value3, double value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, double value2, boolean value3, double value4);

  public native Object uniform4i(WebGLUniformLocation location, double value1, boolean value2, boolean value3, double value4);

  public native Object uniform4i(WebGLUniformLocation location, boolean value1, boolean value2, boolean value3, double value4);

  public native Object uniform4iv(WebGLUniformLocation location, Object[] value);

  public native Object uniform4iv(WebGLUniformLocation location, Int32Array value);

  public native Object uniformMatrix2fv(WebGLUniformLocation location, boolean transpose, double[] data);

  public native Object uniformMatrix2fv(WebGLUniformLocation location, boolean transpose, Float32Array data);

  public native Object uniformMatrix3fv(WebGLUniformLocation location, boolean transpose, double[] data);

  public native Object uniformMatrix3fv(WebGLUniformLocation location, boolean transpose, Float32Array data);

  public native Object uniformMatrix4fv(WebGLUniformLocation location, boolean transpose, double[] data);

  public native Object uniformMatrix4fv(WebGLUniformLocation location, boolean transpose, Float32Array data);

  public native Object useProgram(WebGLProgram program);

  public native Object validateProgram(WebGLProgram program);

  public native Object vertexAttrib1f(double indx, double x);

  public native Object vertexAttrib1fv(double indx, double[] values);

  public native Object vertexAttrib1fv(double indx, Float32Array values);

  public native Object vertexAttrib2f(double indx, double x, double y);

  public native Object vertexAttrib2fv(double indx, double[] values);

  public native Object vertexAttrib2fv(double indx, Float32Array values);

  public native Object vertexAttrib3f(double indx, double x, double y, double z);

  public native Object vertexAttrib3fv(double indx, double[] values);

  public native Object vertexAttrib3fv(double indx, Float32Array values);

  public native Object vertexAttrib4f(double indx, double x, double y, double z, double w);

  public native Object vertexAttrib4fv(double indx, double[] values);

  public native Object vertexAttrib4fv(double indx, Float32Array values);

  public native Object vertexAttribPointer(double indx, double size, double type, boolean normalized, double stride, double offset);

  public native Object viewport(double x, double y, double width, double height);

}
