/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.Object;
import elemental2.Iterable;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class WeakMap<KEY, VALUE> {
  public WeakMap(/* KEY | VALUE */ Object[][] iterable) {}

  public WeakMap() {}

  public WeakMap(Iterable</* KEY | VALUE */ Object[]> iterable) {}

  public native void clear();

  public native boolean delete(KEY a);

  public native VALUE get(KEY a);

  public native boolean has(KEY a);

  public native <THIS> THIS set(KEY a, VALUE b);

}
