/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import java.lang.Object;
import elemental2.Node;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class UserDataHandler {
  public double NODE_ADOPTED;
  public double NODE_CLONED;
  public double NODE_DELETED;
  public double NODE_IMPORTED;
  public double NODE_RENAMED;
  
  public native void handle(double operation, String key, Object data, Node src, Node dst);

  public native void handle(double operation, String key);

  public native void handle(double operation, String key, Object data);

  public native void handle(double operation, String key, Object data, Node src);

}
