/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.ArrayBufferView;
import elemental2.ITypedArray;
import jsinterop.annotations.JsFunction;
import elemental2.Uint8Array.FromOpt_mapFnCallback;
import elemental2.ArrayBuffer;
import jsinterop.annotations.JsOverlay;
import jsinterop.helper.JsObjects;
import java.lang.Object;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Uint8Array extends ArrayBufferView implements ITypedArray {
  @JsFunction
  public interface FromOpt_mapFnCallback {
    double onInvoke(double a);

  }
  public static double BYTES_PER_ELEMENT;
  
  public static native <S> Uint8Array from(double[] source, FromOpt_mapFnCallback mapFn, S this_);

  public static native Uint8Array from(double[] source);

  public static native Uint8Array from(double[] source, FromOpt_mapFnCallback mapFn);

  public static native Uint8Array of(double... var_args);

  public double length;
  
  public Uint8Array(ArrayBuffer length, double byteOffset, double length0) {}

  public Uint8Array(double length, double byteOffset, double length0) {}

  public Uint8Array(ArrayBufferView length, double byteOffset, double length0) {}

  public Uint8Array(double[] length, double byteOffset, double length0) {}

  public Uint8Array(ArrayBuffer length) {}

  public Uint8Array(double length) {}

  public Uint8Array(ArrayBufferView length) {}

  public Uint8Array(double[] length) {}

  public Uint8Array(ArrayBuffer length, double byteOffset) {}

  public Uint8Array(double length, double byteOffset) {}

  public Uint8Array(ArrayBufferView length, double byteOffset) {}

  public Uint8Array(double[] length, double byteOffset) {}

  @JsOverlay
  public final double get(double key){
    return JsObjects.get(this, key);
  }

  public native Object copyWithin(double target, double start, double end);

  public native Object copyWithin(double target, double start);

  public native Uint8Array fill(double value, double begin, double end);

  public native Uint8Array fill(double value);

  public native Uint8Array fill(double value, double begin);

  public native Object set(double[] array, double offset);

  public native Object set(ArrayBufferView array, double offset);

  public native Object set(double[] array);

  public native Object set(ArrayBufferView array);

  public native Uint8Array subarray(double begin, double end);

  public native Uint8Array subarray(double begin);

  @JsProperty(name = "BYTES_PER_ELEMENT")
  public native void setBYTES_PER_ELEMENT(double BYTES_PER_ELEMENT);

  @JsProperty(name = "BYTES_PER_ELEMENT")
  public native double getBYTES_PER_ELEMENT();

  @JsProperty
  public native void setLength(double length);

  @JsProperty
  public native double getLength();

}
