/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.UIEvent;
import jsinterop.annotations.JsProperty;
import elemental2.Touch;
import elemental2.EventTarget;
import elemental2.Window;
import elemental2.TouchList;
import java.lang.String;
import elemental2.TouchEvent.TouchEvent_InstanceOpt_eventInitDictType;
import elemental2.UIEvent.UIEvent_InstanceOpt_eventInitDictType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class TouchEvent extends UIEvent {
  @JsType
  public interface TouchEvent_InstanceOpt_eventInitDictType {
    @JsProperty
    void setBubbles(boolean bubbles);

    @JsProperty
    boolean isBubbles();

    @JsProperty
    void setCancelable(boolean cancelable);

    @JsProperty
    boolean isCancelable();

    @JsProperty
    void setChangedTouches(Touch[] changedTouches);

    @JsProperty
    Touch[] getChangedTouches();

    @JsProperty
    void setDetail(double detail);

    @JsProperty
    double getDetail();

    @JsProperty
    void setRelatedTarget(EventTarget relatedTarget);

    @JsProperty
    EventTarget getRelatedTarget();

    @JsProperty
    void setTargetTouches(Touch[] targetTouches);

    @JsProperty
    Touch[] getTargetTouches();

    @JsProperty
    void setTouches(Touch[] touches);

    @JsProperty
    Touch[] getTouches();

    @JsProperty
    void setView(Window view);

    @JsProperty
    Window getView();

  }
  public boolean altKey;
  public TouchList changedTouches;
  public boolean ctrlKey;
  public boolean metaKey;
  public boolean shiftKey;
  public TouchList targetTouches;
  public TouchList touches;
  
  public TouchEvent(String type, TouchEvent_InstanceOpt_eventInitDictType eventInitDict) {
    // This call is only there for java compilation purpose.
    super((String) null, (UIEvent_InstanceOpt_eventInitDictType) null);
  }

  public TouchEvent(String type) {
    // This call is only there for java compilation purpose.
    super((String) null, (UIEvent_InstanceOpt_eventInitDictType) null);
  }

  
}
