/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import elemental2.EventTarget;
import elemental2.Touch.Touch_InstanceTouchInitDictType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Touch {
  @JsType
  public interface Touch_InstanceTouchInitDictType {
    @JsProperty
    void setClientX(double clientX);

    @JsProperty
    double getClientX();

    @JsProperty
    void setClientY(double clientY);

    @JsProperty
    double getClientY();

    @JsProperty
    void setForce(double force);

    @JsProperty
    double getForce();

    @JsProperty
    void setIdentifier(double identifier);

    @JsProperty
    double getIdentifier();

    @JsProperty
    void setPageX(double pageX);

    @JsProperty
    double getPageX();

    @JsProperty
    void setPageY(double pageY);

    @JsProperty
    double getPageY();

    @JsProperty
    void setRadiusX(double radiusX);

    @JsProperty
    double getRadiusX();

    @JsProperty
    void setRadiusY(double radiusY);

    @JsProperty
    double getRadiusY();

    @JsProperty
    void setRotationAngle(double rotationAngle);

    @JsProperty
    double getRotationAngle();

    @JsProperty
    void setScreenX(double screenX);

    @JsProperty
    double getScreenX();

    @JsProperty
    void setScreenY(double screenY);

    @JsProperty
    double getScreenY();

    @JsProperty
    void setTarget(EventTarget target);

    @JsProperty
    EventTarget getTarget();

  }
  public double clientX;
  public double clientY;
  public double force;
  public double identifier;
  public double pageX;
  public double pageY;
  public double radiusX;
  public double radiusY;
  public double rotationAngle;
  public double screenX;
  public double screenY;
  public EventTarget target;
  
  public Touch(Touch_InstanceTouchInitDictType touchInitDict) {}

  
}
