/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.IArrayLike;
import elemental2.TextTrack;
import jsinterop.annotations.JsOverlay;
import jsinterop.helper.JsObjects;
import java.lang.String;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class TextTrackList implements IArrayLike<TextTrack> {
  public double length;
  
  @JsOverlay
  public final TextTrack get(double key){
    return JsObjects.get(this, key);
  }

  public native TextTrack getTrackById(String id);

  @JsProperty
  public native void setLength(double length);

  @JsProperty
  public native double getLength();

}
