/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import elemental2.NativeObject;
import elemental2.ArrayBufferView;
import elemental2.ArrayBuffer;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class TextDecoder {
  public String encoding;
  public boolean fatal;
  public boolean ignoreBOM;
  
  public TextDecoder(String encoding, NativeObject options) {}

  public TextDecoder() {}

  public TextDecoder(String encoding) {}

  public native String decode(ArrayBufferView input, NativeObject options);

  public native String decode();

  public native String decode(ArrayBuffer input, NativeObject options);

  public native String decode(ArrayBufferView input);

  public native String decode(ArrayBuffer input);

}
