/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import elemental2.SpeechRecognitionError;
import elemental2.SpeechRecognitionEvent;
import elemental2.SpeechGrammarList;
import java.lang.String;
import elemental2.SpeechRecognition.OnaudioendCallback;
import elemental2.SpeechRecognition.OnaudiostartCallback;
import elemental2.SpeechRecognition.OnendCallback;
import elemental2.SpeechRecognition.OnerrorCallback;
import elemental2.SpeechRecognition.OnnomatchCallback;
import elemental2.SpeechRecognition.OnresultCallback;
import elemental2.SpeechRecognition.OnsoundendCallback;
import elemental2.SpeechRecognition.OnsoundstartCallback;
import elemental2.SpeechRecognition.OnspeechendCallback;
import elemental2.SpeechRecognition.OnspeechstartCallback;
import elemental2.SpeechRecognition.OnstartCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SpeechRecognition {
  @JsFunction
  public interface OnaudioendCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnaudiostartCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnendCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(SpeechRecognitionError a);

  }
  @JsFunction
  public interface OnnomatchCallback {
    Object onInvoke(SpeechRecognitionEvent a);

  }
  @JsFunction
  public interface OnresultCallback {
    Object onInvoke(SpeechRecognitionEvent a);

  }
  @JsFunction
  public interface OnsoundendCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnsoundstartCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnspeechendCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnspeechstartCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnstartCallback {
    Object onInvoke(Event a);

  }
  public boolean continuous;
  public SpeechGrammarList grammars;
  public boolean interimResults;
  public String lang;
  public double maxAlternatives;
  public OnaudioendCallback onaudioend;
  public OnaudiostartCallback onaudiostart;
  public OnendCallback onend;
  public OnerrorCallback onerror;
  public OnnomatchCallback onnomatch;
  public OnresultCallback onresult;
  public OnsoundendCallback onsoundend;
  public OnsoundstartCallback onsoundstart;
  public OnspeechendCallback onspeechend;
  public OnspeechstartCallback onspeechstart;
  public OnstartCallback onstart;
  public String serviceURI;
  
  public native Object abort();

  public native Object start();

  public native Object stop();

}
