/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Iterable;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.IteratorIterable;
import elemental2.Set.ForEachACallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Set<VALUE> implements Iterable<VALUE> {
  @JsFunction
  public interface ForEachACallback<VALUE, SET> {
    Object onInvoke(VALUE a, VALUE b, SET c);

  }
  public double size;
  
  public Set(VALUE[] iterable) {}

  public Set() {}

  public Set(Iterable<VALUE> iterable) {}

  public native <THIS> THIS add(VALUE a);

  public native void clear();

  public native boolean delete(VALUE a);

  public native IteratorIterable<VALUE[]> entries();

  public native <SET, THIS> Object forEach(ForEachACallback<VALUE, SET> a, THIS b);

  public native <SET> Object forEach(ForEachACallback<VALUE, SET> a);

  public native boolean has(VALUE a);

  public native IteratorIterable<VALUE> keys();

  public native IteratorIterable<VALUE> values();

}
