/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import jsinterop.annotations.JsProperty;
import elemental2.ServiceWorker;
import elemental2.Promise;
import elemental2.ServiceWorkerRegistration.OnupdatefoundCallback;
import elemental2.PushManager;
import java.lang.String;
import java.lang.Void;
import java.lang.Boolean;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ServiceWorkerRegistration extends EventTarget {
  @JsFunction
  public interface OnupdatefoundCallback {
    Object onInvoke(Event a);

  }
  @JsProperty
  void setActive(ServiceWorker active);

  @JsProperty
  ServiceWorker getActive();

  Promise<Object[]> getNotifications(Object filter);

  Promise<Object[]> getNotifications();

  @JsProperty
  void setInstalling(ServiceWorker installing);

  @JsProperty
  ServiceWorker getInstalling();

  @JsProperty
  void setOnupdatefound(OnupdatefoundCallback onupdatefound);

  @JsProperty
  OnupdatefoundCallback getOnupdatefound();

  @JsProperty
  void setPushManager(PushManager pushManager);

  @JsProperty
  PushManager getPushManager();

  @JsProperty
  void setScope(String scope);

  @JsProperty
  String getScope();

  Promise<Void> showNotification(String title, Object options);

  Promise<Void> showNotification(String title);

  Promise<Boolean> unregister();

  Object update();

  @JsProperty
  void setWaiting(ServiceWorker waiting);

  @JsProperty
  ServiceWorker getWaiting();

}
