/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.WorkerGlobalScope;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.ExtendableEvent;
import elemental2.Event;
import elemental2.FetchEvent;
import elemental2.InstallEvent;
import elemental2.MessageEvent;
import jsinterop.annotations.JsProperty;
import elemental2.CacheStorage;
import elemental2.ServiceWorkerClients;
import elemental2.IDBFactory;
import elemental2.ServiceWorkerGlobalScope.OnactivateCallback;
import elemental2.ServiceWorkerGlobalScope.OnbeforeevictedCallback;
import elemental2.ServiceWorkerGlobalScope.OnevictedCallback;
import elemental2.ServiceWorkerGlobalScope.OnfetchCallback;
import elemental2.ServiceWorkerGlobalScope.OninstallCallback;
import elemental2.ServiceWorkerGlobalScope.OnmessageCallback;
import elemental2.ServiceWorkerRegistration;
import java.lang.String;
import elemental2.Cache;
import elemental2.Promise;
import java.lang.Void;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ServiceWorkerGlobalScope extends WorkerGlobalScope {
  @JsFunction
  public interface OnactivateCallback {
    Object onInvoke(ExtendableEvent a);

  }
  @JsFunction
  public interface OnbeforeevictedCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnevictedCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnfetchCallback {
    Object onInvoke(FetchEvent a);

  }
  @JsFunction
  public interface OninstallCallback {
    Object onInvoke(InstallEvent a);

  }
  @JsFunction
  public interface OnmessageCallback<Object> {
    Object onInvoke(MessageEvent<Object> a);

  }
  @JsProperty
  void setCaches(CacheStorage caches);

  @JsProperty
  CacheStorage getCaches();

  @JsProperty
  void setClients(ServiceWorkerClients clients);

  @JsProperty
  ServiceWorkerClients getClients();

  @JsProperty
  void setConsole(Object console);

  @JsProperty
  Object getConsole();

  @JsProperty
  void setIndexedDB(IDBFactory indexedDB);

  @JsProperty
  IDBFactory getIndexedDB();

  @JsProperty
  void setOnactivate(OnactivateCallback onactivate);

  @JsProperty
  OnactivateCallback getOnactivate();

  @JsProperty
  void setOnbeforeevicted(OnbeforeevictedCallback onbeforeevicted);

  @JsProperty
  OnbeforeevictedCallback getOnbeforeevicted();

  @JsProperty
  void setOnevicted(OnevictedCallback onevicted);

  @JsProperty
  OnevictedCallback getOnevicted();

  @JsProperty
  void setOnfetch(OnfetchCallback onfetch);

  @JsProperty
  OnfetchCallback getOnfetch();

  @JsProperty
  void setOninstall(OninstallCallback oninstall);

  @JsProperty
  OninstallCallback getOninstall();

  @JsProperty
  void setOnmessage(OnmessageCallback<Object> onmessage);

  @JsProperty
  OnmessageCallback getOnmessage();

  @JsProperty
  void setRegistration(ServiceWorkerRegistration registration);

  @JsProperty
  ServiceWorkerRegistration getRegistration();

  @JsProperty
  void setScope(String scope);

  @JsProperty
  String getScope();

  @JsProperty
  void setScriptCache(Cache scriptCache);

  @JsProperty
  Cache getScriptCache();

  Promise<Void> skipWaiting();

}
