/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import elemental2.ErrorEvent;
import elemental2.ServiceWorker;
import elemental2.Promise;
import elemental2.ServiceWorkerRegistration;
import elemental2.ServiceWorkerContainer.OncontrollerchangeCallback;
import elemental2.ServiceWorkerContainer.OnerrorCallback;
import elemental2.ServiceWorkerContainer.RegisterOpt_optionsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ServiceWorkerContainer extends EventTarget {
  @JsType
  public interface RegisterOpt_optionsType {
    @JsProperty
    void setScope(String scope);

    @JsProperty
    String getScope();

  }
  @JsFunction
  public interface OncontrollerchangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(ErrorEvent a);

  }
  @JsProperty
  void setController(ServiceWorker controller);

  @JsProperty
  ServiceWorker getController();

  Promise<ServiceWorkerRegistration> getRegistration(String documentURL);

  Promise<ServiceWorkerRegistration> getRegistration();

  Promise<ServiceWorkerRegistration[]> getRegistrations();

  @JsProperty
  void setOncontrollerchange(OncontrollerchangeCallback oncontrollerchange);

  @JsProperty
  OncontrollerchangeCallback getOncontrollerchange();

  @JsProperty
  void setOnerror(OnerrorCallback onerror);

  @JsProperty
  OnerrorCallback getOnerror();

  @JsProperty
  void setReady(Promise<ServiceWorkerRegistration> ready);

  @JsProperty
  Promise<ServiceWorkerRegistration> getReady();

  Promise<ServiceWorkerRegistration> register(String scriptURL, RegisterOpt_optionsType options);

  Promise<ServiceWorkerRegistration> register(String scriptURL);

}
