/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import elemental2.Promise;
import java.lang.Void;
import elemental2.ServiceWorkerClient;
import elemental2.ServiceWorkerClients.GetAllOpt_optionsType;
import elemental2.ServiceWorkerClients.MatchAllOpt_optionsType;
import java.lang.String;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ServiceWorkerClients {
  @JsType
  public interface GetAllOpt_optionsType {
    @JsProperty
    void setIncludeUncontrolled(boolean includeUncontrolled);

    @JsProperty
    boolean isIncludeUncontrolled();

  }
  @JsType
  public interface MatchAllOpt_optionsType {
    @JsProperty
    void setIncludeUncontrolled(boolean includeUncontrolled);

    @JsProperty
    boolean isIncludeUncontrolled();

  }
  Promise<Void> claim();

  Promise<ServiceWorkerClient[]> getAll(GetAllOpt_optionsType options);

  Promise<ServiceWorkerClient[]> getAll();

  Promise<ServiceWorkerClient[]> matchAll(MatchAllOpt_optionsType options);

  Promise<ServiceWorkerClient[]> matchAll();

  Promise<ServiceWorkerClient> openWindow(String url);

}
