/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface SVGZoomAndPan {
  @JsProperty(name = "SVG_ZOOMANDPAN_DISABLE")
  void setSVG_ZOOMANDPAN_DISABLE(double SVG_ZOOMANDPAN_DISABLE);

  @JsProperty(name = "SVG_ZOOMANDPAN_DISABLE")
  double getSVG_ZOOMANDPAN_DISABLE();

  @JsProperty(name = "SVG_ZOOMANDPAN_MAGNIFY")
  void setSVG_ZOOMANDPAN_MAGNIFY(double SVG_ZOOMANDPAN_MAGNIFY);

  @JsProperty(name = "SVG_ZOOMANDPAN_MAGNIFY")
  double getSVG_ZOOMANDPAN_MAGNIFY();

  @JsProperty(name = "SVG_ZOOMANDPAN_UNKNOWN")
  void setSVG_ZOOMANDPAN_UNKNOWN(double SVG_ZOOMANDPAN_UNKNOWN);

  @JsProperty(name = "SVG_ZOOMANDPAN_UNKNOWN")
  double getSVG_ZOOMANDPAN_UNKNOWN();

  @JsProperty
  void setZoomAndPan(double zoomAndPan);

  @JsProperty
  double getZoomAndPan();

}
