/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGZoomAndPan;
import elemental2.SVGFitToViewBox;
import elemental2.SVGAnimatedPreserveAspectRatio;
import java.lang.String;
import elemental2.SVGTransformList;
import elemental2.SVGAnimatedRect;
import elemental2.SVGElement;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGViewSpec implements SVGZoomAndPan, SVGFitToViewBox {
  public static double SVG_ZOOMANDPAN_DISABLE;
  public static double SVG_ZOOMANDPAN_MAGNIFY;
  public static double SVG_ZOOMANDPAN_UNKNOWN;
  
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public String preserveAspectRatioString;
  public SVGTransformList transform;
  public String transformString;
  public SVGAnimatedRect viewBox;
  public String viewBoxString;
  public SVGElement viewTarget;
  public String viewTargetString;
  public double zoomAndPan;
  
  @JsProperty(name = "SVG_ZOOMANDPAN_DISABLE")
  public native void setSVG_ZOOMANDPAN_DISABLE(double SVG_ZOOMANDPAN_DISABLE);

  @JsProperty(name = "SVG_ZOOMANDPAN_DISABLE")
  public native double getSVG_ZOOMANDPAN_DISABLE();

  @JsProperty(name = "SVG_ZOOMANDPAN_MAGNIFY")
  public native void setSVG_ZOOMANDPAN_MAGNIFY(double SVG_ZOOMANDPAN_MAGNIFY);

  @JsProperty(name = "SVG_ZOOMANDPAN_MAGNIFY")
  public native double getSVG_ZOOMANDPAN_MAGNIFY();

  @JsProperty(name = "SVG_ZOOMANDPAN_UNKNOWN")
  public native void setSVG_ZOOMANDPAN_UNKNOWN(double SVG_ZOOMANDPAN_UNKNOWN);

  @JsProperty(name = "SVG_ZOOMANDPAN_UNKNOWN")
  public native double getSVG_ZOOMANDPAN_UNKNOWN();

  @JsProperty
  public native void setZoomAndPan(double zoomAndPan);

  @JsProperty
  public native double getZoomAndPan();

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native SVGAnimatedRect getViewBox();

}
