/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGMatrix;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGTransform {
  public static double SVG_TRANSFORM_MATRIX;
  public static double SVG_TRANSFORM_ROTATE;
  public static double SVG_TRANSFORM_SCALE;
  public static double SVG_TRANSFORM_SKEWX;
  public static double SVG_TRANSFORM_SKEWY;
  public static double SVG_TRANSFORM_TRANSLATE;
  public static double SVG_TRANSFORM_UNKNOWN;
  
  public double angle;
  public SVGMatrix matrix;
  public double type;
  
  public native Object setMatrix(SVGMatrix matrix);

  public native Object setRotate(double angle, double cx, double cy);

  public native Object setScale(double sx, double sy);

  public native Object setSkewX(double angle);

  public native Object setSkewY(double angle);

  public native Object setTranslate(double tx, double ty);

}
