/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGLangSpace;
import elemental2.SVGStylable;
import elemental2.SVGAnimatedString;
import java.lang.Object;
import java.lang.String;
import elemental2.CSSValue;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGTitleElement extends SVGElement implements SVGLangSpace, SVGStylable {
  public SVGAnimatedString className;
  public /* String | CSSStyleDeclaration */ Object style;
  public String xmllang;
  public String xmlspace;
  
  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native void setXmlspace(String xmlspace);

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

}
