/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGTextPositioningElement;
import elemental2.SVGTransformable;
import elemental2.SVGElement;
import elemental2.SVGAnimatedTransformList;
import elemental2.SVGRect;
import elemental2.SVGMatrix;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGTextElement extends SVGTextPositioningElement implements SVGTransformable {
  public SVGElement farthestViewportElement;
  public SVGElement nearestViewportElement;
  public SVGAnimatedTransformList transform;
  
  public native SVGRect getBBox();

  public native SVGMatrix getCTM();

  public native SVGMatrix getScreenCTM();

  public native SVGMatrix getTransformToElement(SVGElement element);

  public native SVGMatrix getTransformToElement();

  @JsProperty
  public native void setTransform(SVGAnimatedTransformList transform);

  @JsProperty
  public native SVGAnimatedTransformList getTransform();

  @JsProperty
  public native void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  public native SVGElement getFarthestViewportElement();

  @JsProperty
  public native void setNearestViewportElement(SVGElement nearestViewportElement);

  @JsProperty
  public native SVGElement getNearestViewportElement();

}
