/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGTests;
import elemental2.SVGLangSpace;
import elemental2.SVGExternalResourcesRequired;
import elemental2.SVGStylable;
import elemental2.SVGLocatable;
import elemental2.SVGFitToViewBox;
import elemental2.SVGZoomAndPan;
import elemental2.SVGAnimatedString;
import java.lang.String;
import elemental2.SVGPoint;
import elemental2.SVGAnimatedBoolean;
import elemental2.SVGAnimatedLength;
import elemental2.SVGAnimatedPreserveAspectRatio;
import elemental2.SVGStringList;
import java.lang.Object;
import elemental2.SVGAnimatedRect;
import elemental2.SVGRect;
import elemental2.SVGAngle;
import elemental2.SVGLength;
import elemental2.SVGMatrix;
import elemental2.SVGNumber;
import elemental2.SVGTransform;
import elemental2.Element;
import elemental2.NodeList;
import elemental2.CSSValue;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGSVGElement extends SVGElement implements SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGLocatable, SVGFitToViewBox, SVGZoomAndPan {
  public static double SVG_ZOOMANDPAN_DISABLE;
  public static double SVG_ZOOMANDPAN_MAGNIFY;
  public static double SVG_ZOOMANDPAN_UNKNOWN;
  
  public SVGAnimatedString className;
  public String contentScriptType;
  public String contentStyleType;
  public double currentScale;
  public SVGPoint currentTranslate;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGElement farthestViewportElement;
  public SVGAnimatedLength height;
  public SVGElement nearestViewportElement;
  public double pixelUnitToMillimeterX;
  public double pixelUnitToMillimeterY;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGStringList requiredExtensions;
  public SVGStringList requiredFeatures;
  public double screenPixelToMillimeterX;
  public double screenPixelToMillimeterY;
  public /* String | CSSStyleDeclaration */ Object style;
  public SVGStringList systemLanguage;
  public boolean useCurrentView;
  public SVGAnimatedRect viewBox;
  public SVGRect viewport;
  public SVGAnimatedLength width;
  public SVGAnimatedLength x;
  public String xmllang;
  public String xmlspace;
  public SVGAnimatedLength y;
  public double zoomAndPan;
  
  public native boolean animationsPaused();

  public native boolean checkEnclosure(SVGElement element, SVGRect rect);

  public native boolean checkEnclosure();

  public native boolean checkEnclosure(SVGElement element);

  public native boolean checkIntersection(SVGElement element, SVGRect rect);

  public native boolean checkIntersection();

  public native boolean checkIntersection(SVGElement element);

  public native SVGAngle createSVGAngle();

  public native SVGLength createSVGLength();

  public native SVGMatrix createSVGMatrix();

  public native SVGNumber createSVGNumber();

  public native SVGPoint createSVGPoint();

  public native SVGRect createSVGRect();

  public native SVGTransform createSVGTransform();

  public native SVGTransform createSVGTransformFromMatrix(SVGMatrix matrix);

  public native SVGTransform createSVGTransformFromMatrix();

  public native Object deselectAll();

  public native Object forceRedraw();

  public native SVGRect getBBox();

  public native SVGMatrix getCTM();

  public native double getCurrentTime();

  public native Element getElementById(String elementId);

  public native Element getElementById();

  public native NodeList<Object> getEnclosureList(SVGRect rect, SVGElement referenceElement);

  public native NodeList<Object> getEnclosureList();

  public native NodeList<Object> getEnclosureList(SVGRect rect);

  public native NodeList<Object> getIntersectionList(SVGRect rect, SVGElement referenceElement);

  public native NodeList<Object> getIntersectionList();

  public native NodeList<Object> getIntersectionList(SVGRect rect);

  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  public native SVGMatrix getScreenCTM();

  public native SVGMatrix getTransformToElement(SVGElement element);

  public native SVGMatrix getTransformToElement();

  public native boolean hasExtension(String extension);

  public native boolean hasExtension();

  public native Object pauseAnimations();

  public native Object setCurrentTime(double seconds);

  public native Object setCurrentTime();

  public native double suspendRedraw(double maxWaitMilliseconds);

  public native double suspendRedraw();

  public native Object unpauseAnimations();

  public native Object unsuspendRedraw(double suspendHandleId);

  public native Object unsuspendRedraw();

  public native Object unsuspendRedrawAll();

  @JsProperty
  public native void setRequiredExtensions(SVGStringList requiredExtensions);

  @JsProperty
  public native SVGStringList getRequiredExtensions();

  @JsProperty
  public native void setRequiredFeatures(SVGStringList requiredFeatures);

  @JsProperty
  public native SVGStringList getRequiredFeatures();

  @JsProperty
  public native void setSystemLanguage(SVGStringList systemLanguage);

  @JsProperty
  public native SVGStringList getSystemLanguage();

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native void setXmlspace(String xmlspace);

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

  @JsProperty
  public native void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  public native SVGElement getFarthestViewportElement();

  @JsProperty
  public native void setNearestViewportElement(SVGElement nearestViewportElement);

  @JsProperty
  public native SVGElement getNearestViewportElement();

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty(name = "SVG_ZOOMANDPAN_DISABLE")
  public native void setSVG_ZOOMANDPAN_DISABLE(double SVG_ZOOMANDPAN_DISABLE);

  @JsProperty(name = "SVG_ZOOMANDPAN_DISABLE")
  public native double getSVG_ZOOMANDPAN_DISABLE();

  @JsProperty(name = "SVG_ZOOMANDPAN_MAGNIFY")
  public native void setSVG_ZOOMANDPAN_MAGNIFY(double SVG_ZOOMANDPAN_MAGNIFY);

  @JsProperty(name = "SVG_ZOOMANDPAN_MAGNIFY")
  public native double getSVG_ZOOMANDPAN_MAGNIFY();

  @JsProperty(name = "SVG_ZOOMANDPAN_UNKNOWN")
  public native void setSVG_ZOOMANDPAN_UNKNOWN(double SVG_ZOOMANDPAN_UNKNOWN);

  @JsProperty(name = "SVG_ZOOMANDPAN_UNKNOWN")
  public native double getSVG_ZOOMANDPAN_UNKNOWN();

  @JsProperty
  public native void setZoomAndPan(double zoomAndPan);

  @JsProperty
  public native double getZoomAndPan();

}
