/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGTests;
import elemental2.SVGLangSpace;
import elemental2.SVGExternalResourcesRequired;
import elemental2.SVGStylable;
import elemental2.SVGTransformable;
import elemental2.SVGPathSegList;
import elemental2.SVGAnimatedString;
import elemental2.SVGAnimatedBoolean;
import elemental2.SVGAnimatedNumber;
import elemental2.SVGStringList;
import java.lang.Object;
import elemental2.SVGAnimatedTransformList;
import java.lang.String;
import elemental2.SVGPathSegArcAbs;
import elemental2.SVGPathSegArcRel;
import elemental2.SVGPathSegClosePath;
import elemental2.SVGPathSegCurvetoCubicAbs;
import elemental2.SVGPathSegCurvetoCubicRel;
import elemental2.SVGPathSegCurvetoCubicSmoothAbs;
import elemental2.SVGPathSegCurvetoCubicSmoothRel;
import elemental2.SVGPathSegCurvetoQuadraticAbs;
import elemental2.SVGPathSegCurvetoQuadraticRel;
import elemental2.SVGPathSegCurvetoQuadraticSmoothAbs;
import elemental2.SVGPathSegCurvetoQuadraticSmoothRel;
import elemental2.SVGPathSegLinetoAbs;
import elemental2.SVGPathSegLinetoHorizontalAbs;
import elemental2.SVGPathSegLinetoHorizontalRel;
import elemental2.SVGPathSegLinetoRel;
import elemental2.SVGPathSegLinetoVerticalAbs;
import elemental2.SVGPathSegLinetoVerticalRel;
import elemental2.SVGPathSegMovetoAbs;
import elemental2.SVGPathSegMovetoRel;
import elemental2.SVGRect;
import elemental2.SVGMatrix;
import elemental2.SVGPoint;
import elemental2.CSSValue;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGPathElement extends SVGElement implements SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable {
  public SVGPathSegList animatedNormalizedPathSegList;
  public SVGPathSegList animatedPathSegList;
  public SVGAnimatedString className;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGElement farthestViewportElement;
  public SVGElement nearestViewportElement;
  public SVGPathSegList normalizedPathSegList;
  public SVGAnimatedNumber pathLength;
  public SVGPathSegList pathSegList;
  public SVGStringList requiredExtensions;
  public SVGStringList requiredFeatures;
  public /* String | CSSStyleDeclaration */ Object style;
  public SVGStringList systemLanguage;
  public SVGAnimatedTransformList transform;
  public String xmllang;
  public String xmlspace;
  
  public native SVGPathSegArcAbs createSVGPathSegArcAbs(double x, double y, double r1, double r2, double angle, boolean largeArcFlag, boolean sweepFlag);

  public native SVGPathSegArcAbs createSVGPathSegArcAbs();

  public native SVGPathSegArcAbs createSVGPathSegArcAbs(double x);

  public native SVGPathSegArcAbs createSVGPathSegArcAbs(double x, double y);

  public native SVGPathSegArcAbs createSVGPathSegArcAbs(double x, double y, double r1);

  public native SVGPathSegArcAbs createSVGPathSegArcAbs(double x, double y, double r1, double r2);

  public native SVGPathSegArcAbs createSVGPathSegArcAbs(double x, double y, double r1, double r2, double angle);

  public native SVGPathSegArcAbs createSVGPathSegArcAbs(double x, double y, double r1, double r2, double angle, boolean largeArcFlag);

  public native SVGPathSegArcRel createSVGPathSegArcRel(double x, double y, double r1, double r2, double angle, boolean largeArcFlag, boolean sweepFlag);

  public native SVGPathSegArcRel createSVGPathSegArcRel();

  public native SVGPathSegArcRel createSVGPathSegArcRel(double x);

  public native SVGPathSegArcRel createSVGPathSegArcRel(double x, double y);

  public native SVGPathSegArcRel createSVGPathSegArcRel(double x, double y, double r1);

  public native SVGPathSegArcRel createSVGPathSegArcRel(double x, double y, double r1, double r2);

  public native SVGPathSegArcRel createSVGPathSegArcRel(double x, double y, double r1, double r2, double angle);

  public native SVGPathSegArcRel createSVGPathSegArcRel(double x, double y, double r1, double r2, double angle, boolean largeArcFlag);

  public native SVGPathSegClosePath createSVGPathSegClosePath();

  public native SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs(double x, double y, double x1, double y1, double x2, double y2);

  public native SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs();

  public native SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs(double x);

  public native SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs(double x, double y);

  public native SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs(double x, double y, double x1);

  public native SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs(double x, double y, double x1, double y1);

  public native SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs(double x, double y, double x1, double y1, double x2);

  public native SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel(double x, double y, double x1, double y1, double x2, double y2);

  public native SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel();

  public native SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel(double x);

  public native SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel(double x, double y);

  public native SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel(double x, double y, double x1);

  public native SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel(double x, double y, double x1, double y1);

  public native SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel(double x, double y, double x1, double y1, double x2);

  public native SVGPathSegCurvetoCubicSmoothAbs createSVGPathSegCurvetoCubicSmoothAbs(double x, double y, double x2, double y2);

  public native SVGPathSegCurvetoCubicSmoothAbs createSVGPathSegCurvetoCubicSmoothAbs();

  public native SVGPathSegCurvetoCubicSmoothAbs createSVGPathSegCurvetoCubicSmoothAbs(double x);

  public native SVGPathSegCurvetoCubicSmoothAbs createSVGPathSegCurvetoCubicSmoothAbs(double x, double y);

  public native SVGPathSegCurvetoCubicSmoothAbs createSVGPathSegCurvetoCubicSmoothAbs(double x, double y, double x2);

  public native SVGPathSegCurvetoCubicSmoothRel createSVGPathSegCurvetoCubicSmoothRel(double x, double y, double x2, double y2);

  public native SVGPathSegCurvetoCubicSmoothRel createSVGPathSegCurvetoCubicSmoothRel();

  public native SVGPathSegCurvetoCubicSmoothRel createSVGPathSegCurvetoCubicSmoothRel(double x);

  public native SVGPathSegCurvetoCubicSmoothRel createSVGPathSegCurvetoCubicSmoothRel(double x, double y);

  public native SVGPathSegCurvetoCubicSmoothRel createSVGPathSegCurvetoCubicSmoothRel(double x, double y, double x2);

  public native SVGPathSegCurvetoQuadraticAbs createSVGPathSegCurvetoQuadraticAbs(double x, double y, double x1, double y1);

  public native SVGPathSegCurvetoQuadraticAbs createSVGPathSegCurvetoQuadraticAbs();

  public native SVGPathSegCurvetoQuadraticAbs createSVGPathSegCurvetoQuadraticAbs(double x);

  public native SVGPathSegCurvetoQuadraticAbs createSVGPathSegCurvetoQuadraticAbs(double x, double y);

  public native SVGPathSegCurvetoQuadraticAbs createSVGPathSegCurvetoQuadraticAbs(double x, double y, double x1);

  public native SVGPathSegCurvetoQuadraticRel createSVGPathSegCurvetoQuadraticRel(double x, double y, double x1, double y1);

  public native SVGPathSegCurvetoQuadraticRel createSVGPathSegCurvetoQuadraticRel();

  public native SVGPathSegCurvetoQuadraticRel createSVGPathSegCurvetoQuadraticRel(double x);

  public native SVGPathSegCurvetoQuadraticRel createSVGPathSegCurvetoQuadraticRel(double x, double y);

  public native SVGPathSegCurvetoQuadraticRel createSVGPathSegCurvetoQuadraticRel(double x, double y, double x1);

  public native SVGPathSegCurvetoQuadraticSmoothAbs createSVGPathSegCurvetoQuadraticSmoothAbs(double x, double y);

  public native SVGPathSegCurvetoQuadraticSmoothAbs createSVGPathSegCurvetoQuadraticSmoothAbs();

  public native SVGPathSegCurvetoQuadraticSmoothAbs createSVGPathSegCurvetoQuadraticSmoothAbs(double x);

  public native SVGPathSegCurvetoQuadraticSmoothRel createSVGPathSegCurvetoQuadraticSmoothRel(double x, double y);

  public native SVGPathSegCurvetoQuadraticSmoothRel createSVGPathSegCurvetoQuadraticSmoothRel();

  public native SVGPathSegCurvetoQuadraticSmoothRel createSVGPathSegCurvetoQuadraticSmoothRel(double x);

  public native SVGPathSegLinetoAbs createSVGPathSegLinetoAbs(double x, double y);

  public native SVGPathSegLinetoAbs createSVGPathSegLinetoAbs();

  public native SVGPathSegLinetoAbs createSVGPathSegLinetoAbs(double x);

  public native SVGPathSegLinetoHorizontalAbs createSVGPathSegLinetoHorizontalAbs(double x);

  public native SVGPathSegLinetoHorizontalAbs createSVGPathSegLinetoHorizontalAbs();

  public native SVGPathSegLinetoHorizontalRel createSVGPathSegLinetoHorizontalRel(double x);

  public native SVGPathSegLinetoHorizontalRel createSVGPathSegLinetoHorizontalRel();

  public native SVGPathSegLinetoRel createSVGPathSegLinetoRel(double x, double y);

  public native SVGPathSegLinetoRel createSVGPathSegLinetoRel();

  public native SVGPathSegLinetoRel createSVGPathSegLinetoRel(double x);

  public native SVGPathSegLinetoVerticalAbs createSVGPathSegLinetoVerticalAbs(double y);

  public native SVGPathSegLinetoVerticalAbs createSVGPathSegLinetoVerticalAbs();

  public native SVGPathSegLinetoVerticalRel createSVGPathSegLinetoVerticalRel(double y);

  public native SVGPathSegLinetoVerticalRel createSVGPathSegLinetoVerticalRel();

  public native SVGPathSegMovetoAbs createSVGPathSegMovetoAbs(double x, double y);

  public native SVGPathSegMovetoAbs createSVGPathSegMovetoAbs();

  public native SVGPathSegMovetoAbs createSVGPathSegMovetoAbs(double x);

  public native SVGPathSegMovetoRel createSVGPathSegMovetoRel(double x, double y);

  public native SVGPathSegMovetoRel createSVGPathSegMovetoRel();

  public native SVGPathSegMovetoRel createSVGPathSegMovetoRel(double x);

  public native SVGRect getBBox();

  public native SVGMatrix getCTM();

  public native double getPathSegAtLength(double distance);

  public native double getPathSegAtLength();

  public native SVGPoint getPointAtLength(double distance);

  public native SVGPoint getPointAtLength();

  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  public native SVGMatrix getScreenCTM();

  public native double getTotalLength();

  public native SVGMatrix getTransformToElement(SVGElement element);

  public native SVGMatrix getTransformToElement();

  public native boolean hasExtension(String extension);

  public native boolean hasExtension();

  @JsProperty
  public native void setRequiredExtensions(SVGStringList requiredExtensions);

  @JsProperty
  public native SVGStringList getRequiredExtensions();

  @JsProperty
  public native void setRequiredFeatures(SVGStringList requiredFeatures);

  @JsProperty
  public native SVGStringList getRequiredFeatures();

  @JsProperty
  public native void setSystemLanguage(SVGStringList systemLanguage);

  @JsProperty
  public native SVGStringList getSystemLanguage();

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native void setXmlspace(String xmlspace);

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

  @JsProperty
  public native void setTransform(SVGAnimatedTransformList transform);

  @JsProperty
  public native SVGAnimatedTransformList getTransform();

  @JsProperty
  public native void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  public native SVGElement getFarthestViewportElement();

  @JsProperty
  public native void setNearestViewportElement(SVGElement nearestViewportElement);

  @JsProperty
  public native SVGElement getNearestViewportElement();

}
