/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGNumber;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGNumberList {
  public double numberOfItems;
  
  public native SVGNumber appendItem(SVGNumber item);

  public native Object clear();

  public native SVGNumber getItem(double index);

  public native SVGNumber initialize(SVGNumber item);

  public native SVGNumber insertItemBefore(SVGNumber item, double index);

  public native SVGNumber removeItem(double index);

  public native SVGNumber replaceItem(SVGNumber item, double index);

}
