/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGMatrix {
  public double a;
  public double b;
  public double c;
  public double d;
  public double e;
  public double f;
  
  public native SVGMatrix flipX();

  public native SVGMatrix flipY();

  public native SVGMatrix inverse();

  public native SVGMatrix multiply(SVGMatrix secondMatrix);

  public native SVGMatrix rotate(double angle);

  public native SVGMatrix rotateFromVector(double x, double y);

  public native SVGMatrix scale(double scaleFactor);

  public native SVGMatrix scaleNonUniform(double scaleFactorX, double scaleFactorY);

  public native SVGMatrix skewX(double angle);

  public native SVGMatrix skewY(double angle);

  public native SVGMatrix translate(double x, double y);

}
