/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGLength {
  public static double SVG_LENGTHTYPE_CM;
  public static double SVG_LENGTHTYPE_EMS;
  public static double SVG_LENGTHTYPE_EXS;
  public static double SVG_LENGTHTYPE_IN;
  public static double SVG_LENGTHTYPE_MM;
  public static double SVG_LENGTHTYPE_NUMBER;
  public static double SVG_LENGTHTYPE_PC;
  public static double SVG_LENGTHTYPE_PERCENTAGE;
  public static double SVG_LENGTHTYPE_PT;
  public static double SVG_LENGTHTYPE_PX;
  public static double SVG_LENGTHTYPE_UNKNOWN;
  
  public double unitType;
  public double value;
  public String valueAsString;
  public double valueInSpecifiedUnits;
  
  public native Object convertToSpecifiedUnits(double unitType);

  public native Object newValueSpecifiedUnits(double unitType, double valueInSpecifiedUnits);

}
